/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.guard;

import java.text.ParseException;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.guard.RestGuard;
import org.apache.juneau.rest.guard.RoleMatcher;

public class RoleBasedRestGuard
extends RestGuard {
    private final Set<String> roles;
    private final RoleMatcher roleMatcher;

    public RoleBasedRestGuard(Set<String> declaredRoles, String roleExpression) throws ParseException {
        this.roleMatcher = new RoleMatcher(roleExpression);
        this.roles = new TreeSet<String>(declaredRoles == null ? this.roleMatcher.getRolesInExpression() : declaredRoles);
    }

    @Override
    public boolean isRequestAllowed(RestRequest req) {
        Set<String> userRoles = this.roles.stream().filter(x -> req.isUserInRole((String)x)).collect(Collectors.toSet());
        return this.roleMatcher.matches(userRoles);
    }
}

