/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.function.Supplier;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ObjectUtils;

public class BeanStoreEntry<T> {
    final Supplier<T> bean;
    final Class<T> type;
    final String name;

    public static <T> BeanStoreEntry<T> create(Class<T> type, Supplier<T> bean, String name) {
        return new BeanStoreEntry<T>(type, bean, name);
    }

    protected BeanStoreEntry(Class<T> type, Supplier<T> bean, String name) {
        this.bean = (Supplier)ArgUtils.assertArgNotNull((String)"bean", bean);
        this.type = (Class)ArgUtils.assertArgNotNull((String)"type", type);
        this.name = StringUtils.nullIfEmpty((String)name);
    }

    public boolean matches(Class<?> type) {
        return this.type.equals(type);
    }

    public boolean matches(Class<?> type, String name) {
        name = StringUtils.nullIfEmpty((String)name);
        return this.matches(type) && StringUtils.eq((String)this.name, (String)name);
    }

    public T get() {
        return this.bean.get();
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap().append("type", ClassUtils.simpleClassName(this.getType())).append("bean", ObjectUtils.identity(this.get())).append("name", this.getName());
    }
}

