/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.jetty;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.juneau.internal.SystemEnv;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class JettyLogger
implements LocationAwareLogger {
    private static final boolean SHOW_SOURCE = (Boolean)SystemEnv.env((String)"org.eclipse.jetty.util.log.SOURCE", (Object)((Boolean)SystemEnv.env((String)"org.eclipse.jetty.util.log.javautil.SOURCE", (Object)true)));
    private Level configuredLevel;
    private Logger logger;

    public JettyLogger() {
        this("org.eclipse.jetty.util.log.javautil");
    }

    public JettyLogger(String name) {
        this.logger = Logger.getLogger(name);
        this.configuredLevel = this.logger.getLevel();
    }

    public JettyLogger getLogger(String name) {
        return new JettyLogger(name);
    }

    public String getName() {
        return this.logger.getName();
    }

    public void warn(String msg, Object ... args) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, JettyLogger.format(msg, args), null);
        }
    }

    public void warn(Throwable thrown) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, "", thrown);
        }
    }

    public void warn(String msg, Throwable thrown) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, msg, thrown);
        }
    }

    public void info(String msg, Object ... args) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, JettyLogger.format(msg, args), null);
        }
    }

    public void info(Throwable thrown) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, "", thrown);
        }
    }

    public void info(String msg, Throwable thrown) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, msg, thrown);
        }
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(Level.FINE);
    }

    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this.logger.getLevel();
            this.logger.setLevel(Level.FINE);
        } else {
            this.logger.setLevel(this.configuredLevel);
        }
    }

    public void debug(String msg, Object ... args) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, JettyLogger.format(msg, args), null);
        }
    }

    public void debug(String msg, long arg) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, JettyLogger.format(msg, arg), null);
        }
    }

    public void debug(Throwable thrown) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "", thrown);
        }
    }

    public void debug(String msg, Throwable thrown) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, msg, thrown);
        }
    }

    public void ignore(Throwable ignored) {
        if (this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "IGNORED EXCEPTION ", ignored);
        }
    }

    private static String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        if (args.length == 0) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bi = msg.indexOf("{}", start);
            if (bi < 0) {
                sb.append(msg.substring(start)).append(" ").append(arg);
                start = msg.length();
                continue;
            }
            sb.append(msg.substring(start, bi)).append(String.valueOf(arg));
            start = bi + 2;
        }
        sb.append(msg.substring(start));
        return sb.toString();
    }

    private void log(Level level, String msg, Throwable thrown) {
        LogRecord r = new LogRecord(level, msg);
        if (thrown != null) {
            r.setThrown(thrown);
        }
        r.setLoggerName(this.logger.getName());
        if (SHOW_SOURCE) {
            StackTraceElement[] stack;
            for (StackTraceElement e : stack = new Throwable().getStackTrace()) {
                if (e.getClassName().equals(this.getClass().getName())) continue;
                r.setSourceClassName(e.getClassName());
                r.setSourceMethodName(e.getMethodName());
                break;
            }
        }
        this.logger.log(r);
    }

    private boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void trace(String msg) {
    }

    public void trace(String format, Object arg) {
    }

    public void trace(String format, Object arg1, Object arg2) {
    }

    public void trace(String format, Object ... arguments) {
    }

    public void trace(String msg, Throwable t) {
    }

    public boolean isTraceEnabled(Marker marker) {
        return false;
    }

    public void trace(Marker marker, String msg) {
    }

    public void trace(Marker marker, String format, Object arg) {
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void trace(Marker marker, String format, Object ... argArray) {
    }

    public void trace(Marker marker, String msg, Throwable t) {
    }

    public void debug(String msg) {
    }

    public void debug(String format, Object arg) {
    }

    public void debug(String format, Object arg1, Object arg2) {
    }

    public boolean isDebugEnabled(Marker marker) {
        return false;
    }

    public void debug(Marker marker, String msg) {
    }

    public void debug(Marker marker, String format, Object arg) {
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void debug(Marker marker, String format, Object ... arguments) {
    }

    public void debug(Marker marker, String msg, Throwable t) {
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public void info(String msg) {
    }

    public void info(String format, Object arg) {
    }

    public void info(String format, Object arg1, Object arg2) {
    }

    public boolean isInfoEnabled(Marker marker) {
        return false;
    }

    public void info(Marker marker, String msg) {
    }

    public void info(Marker marker, String format, Object arg) {
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void info(Marker marker, String format, Object ... arguments) {
    }

    public void info(Marker marker, String msg, Throwable t) {
    }

    public boolean isWarnEnabled() {
        return false;
    }

    public void warn(String msg) {
    }

    public void warn(String format, Object arg) {
    }

    public void warn(String format, Object arg1, Object arg2) {
    }

    public boolean isWarnEnabled(Marker marker) {
        return false;
    }

    public void warn(Marker marker, String msg) {
    }

    public void warn(Marker marker, String format, Object arg) {
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void warn(Marker marker, String format, Object ... arguments) {
    }

    public void warn(Marker marker, String msg, Throwable t) {
    }

    public boolean isErrorEnabled() {
        return false;
    }

    public void error(String msg) {
    }

    public void error(String format, Object arg) {
    }

    public void error(String format, Object arg1, Object arg2) {
    }

    public void error(String format, Object ... arguments) {
    }

    public void error(String msg, Throwable t) {
    }

    public boolean isErrorEnabled(Marker marker) {
        return false;
    }

    public void error(Marker marker, String msg) {
    }

    public void error(Marker marker, String format, Object arg) {
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void error(Marker marker, String format, Object ... arguments) {
    }

    public void error(Marker marker, String msg, Throwable t) {
    }

    public void log(Marker marker, String fqcn, int level, String message, Object[] argArray, Throwable t) {
    }
}

