/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.staticfile;

import jakarta.activation.MimetypesFileTypeMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpResources;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.HashCode;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.rest.ResourceSupplier;
import org.apache.juneau.rest.staticfile.StaticFiles;

public class BasicStaticFiles
implements StaticFiles {
    private final Header[] headers;
    private final MimetypesFileTypeMap mimeTypes;
    private final int hashCode;
    private final FileFinder fileFinder;

    public static StaticFiles.Builder create(BeanStore beanStore) {
        return new StaticFiles.Builder(beanStore);
    }

    public BasicStaticFiles(BeanStore beanStore) {
        this(((StaticFiles.Builder)StaticFiles.create(beanStore).type((Class)BasicStaticFiles.class)).dir("static").dir("htdocs").cp(beanStore.getBean(ResourceSupplier.class).get().getResourceClass(), "htdocs", true).cp(beanStore.getBean(ResourceSupplier.class).get().getResourceClass(), "/htdocs", true).caching(1000000L).exclude("(?i).*\\.(class|properties)").headers(new Header[]{HttpHeaders.cacheControl((String)"max-age=86400, public")}));
    }

    public BasicStaticFiles(StaticFiles.Builder builder) {
        this.headers = builder.headers.toArray(new Header[builder.headers.size()]);
        this.mimeTypes = builder.mimeTypes;
        this.hashCode = HashCode.of(this.hashCode(), this.headers);
        this.fileFinder = (FileFinder)builder.fileFinder.build();
    }

    protected BasicStaticFiles() {
        this.headers = new Header[0];
        this.mimeTypes = null;
        this.hashCode = HashCode.of(this.hashCode(), this.headers);
        this.fileFinder = null;
    }

    @Override
    public Optional<HttpResource> resolve(String path, Locale locale) {
        try {
            Optional<InputStream> is = this.getStream(path, locale);
            if (!is.isPresent()) {
                return CollectionUtils.empty();
            }
            return CollectionUtils.optional(HttpResources.streamResource((InputStream)is.get()).setHeaders(new Header[]{HttpHeaders.contentType(this.mimeTypes == null ? null : this.mimeTypes.getContentType(FileUtils.getFileName(path)))}).addHeaders(this.headers));
        }
        catch (IOException e) {
            throw new InternalServerError((Throwable)e);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return super.equals(o) && o instanceof BasicStaticFiles && ObjectUtils.eq(this, (BasicStaticFiles)o, (x, y) -> ObjectUtils.eq(x.headers, y.headers));
    }

    @Override
    public Optional<InputStream> getStream(String name, Locale locale) throws IOException {
        return this.fileFinder.getStream(name, locale);
    }

    @Override
    public Optional<String> getString(String name, Locale locale) throws IOException {
        return this.fileFinder.getString(name, locale);
    }

    public String toString() {
        return JsonMap.filteredMap().append("headers", this.headers).asReadableString();
    }
}

