/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converter;

import org.apache.juneau.BeanSession;
import org.apache.juneau.Value;
import org.apache.juneau.objecttools.MatcherFactory;
import org.apache.juneau.objecttools.ObjectPaginator;
import org.apache.juneau.objecttools.ObjectSearcher;
import org.apache.juneau.objecttools.ObjectSorter;
import org.apache.juneau.objecttools.ObjectViewer;
import org.apache.juneau.objecttools.PageArgs;
import org.apache.juneau.objecttools.SearchArgs;
import org.apache.juneau.objecttools.SortArgs;
import org.apache.juneau.objecttools.ViewArgs;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.rest.httppart.RequestQueryParams;

public final class Queryable
implements RestConverter {
    public static final String SWAGGER_PARAMS = "{in:'query',name:'s',description:'Search.\nKey/value pairs representing column names and search tokens.\n\\'*\\' and \\'?\\' can be used as meta-characters in string fields.\n\\'>\\', \\'>=\\', \\'<\\', and \\'<=\\' can be used as limits on numeric and date fields.\nDate fields can be matched with partial dates (e.g. \\'2018\\' to match any date in the year 2018).',type:'array',collectionFormat:'csv',examples:{example:'?s=Bill*,birthDate>2000'}},{in:'query',name:'v',description:'View.\nColumn names to display.',type:'array',collectionFormat:'csv',examples:{example:'?v=name,birthDate'}},{in:'query',name:'o',description:'Order by.\nColumns to sort by.\nColumn names can be suffixed with \\'+\\' or \\'-\\' to indicate ascending or descending order.\nThe default is ascending order.',type:'array',collectionFormat:'csv',examples:{example:'?o=name,birthDate-'}},{in:'query',name:'p',description:'Position.\nOnly return rows starting at the specified index position (zero-indexed).\nDefault is 0',type:'integer',examples:{example:'?p=100'}},{in:'query',name:'l',description:'Limit.\nOnly return the specified number of rows.\nDefault is 0 (meaning return all rows).',type:'integer',examples:{example:'?l=100'}}";

    @Override
    public Object convert(RestRequest req, Object o) {
        if (o == null) {
            return null;
        }
        Value<Object> v = Value.of(o);
        RequestQueryParams params = req.getQueryParams();
        BeanSession bs = req.getBeanSession();
        params.getSearchArgs().ifPresent(x -> v.set(ObjectSearcher.create(new MatcherFactory[0]).run(bs, v.get(), (SearchArgs)x)));
        params.getSortArgs().ifPresent(x -> v.set(ObjectSorter.create().run(bs, v.get(), (SortArgs)x)));
        params.getViewArgs().ifPresent(x -> v.set(ObjectViewer.create().run(bs, v.get(), (ViewArgs)x)));
        params.getPageArgs().ifPresent(x -> v.set(ObjectPaginator.create().run(bs, v.get(), (PageArgs)x)));
        return v.get();
    }
}

