/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;

public class ReaderParserSession
extends ParserSession {
    private final ReaderParser ctx;
    private final Charset fileCharset;
    private final Charset streamCharset;

    public static Builder create(ReaderParser ctx) {
        return new Builder(ctx);
    }

    protected ReaderParserSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.fileCharset = builder.fileCharset;
        this.streamCharset = builder.streamCharset;
    }

    @Override
    public final boolean isReaderParser() {
        return true;
    }

    @Override
    public final ParserPipe createPipe(Object input) {
        return this.setPipe(new ParserPipe(input, this.isDebug(), this.ctx.isStrict(), this.ctx.isAutoCloseStreams(), this.ctx.isUnbuffered(), this.streamCharset, this.fileCharset));
    }

    public Charset getFileCharset() {
        return this.fileCharset;
    }

    public Charset getStreamCharset() {
        return this.streamCharset;
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("fileCharset", this.fileCharset, "streamCharset", this.streamCharset);
    }

    @FluentSetters
    public static class Builder
    extends ParserSession.Builder {
        ReaderParser ctx;
        Charset fileCharset;
        Charset streamCharset;

        protected Builder(ReaderParser ctx) {
            super(ctx);
            this.ctx = ctx;
            this.fileCharset = ctx.fileCharset;
            this.streamCharset = ctx.streamCharset;
        }

        @Override
        public ReaderParserSession build() {
            return new ReaderParserSession(this);
        }

        @FluentSetter
        public Builder fileCharset(Charset value) {
            this.fileCharset = value;
            return this;
        }

        @FluentSetter
        public Builder streamCharset(Charset value) {
            this.streamCharset = value;
            return this;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }
    }
}

