/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Context;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.utils.HashKey;

public class ClasspathStore
extends ConfigStore {
    public static final ClasspathStore DEFAULT = ClasspathStore.create().build();
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();

    public static Builder create() {
        return new Builder();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    public ClasspathStore(Builder builder) {
        super(builder);
    }

    @Override
    public synchronized String read(String name) throws IOException {
        String s = this.cache.get(name);
        if (s != null) {
            return s;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try (InputStream in = cl.getResourceAsStream(name);){
            if (in != null) {
                this.cache.put(name, IOUtils.read(in));
            }
        }
        return StringUtils.emptyIfNull(this.cache.get(name));
    }

    @Override
    public synchronized String write(String name, String expectedContents, String newContents) throws IOException {
        if (StringUtils.eq(expectedContents, newContents)) {
            return null;
        }
        String currentContents = this.read(name);
        if (expectedContents != null && !StringUtils.eq(currentContents, expectedContents)) {
            return currentContents;
        }
        this.update(name, newContents);
        return null;
    }

    @Override
    public synchronized boolean exists(String name) {
        try {
            return !this.read(name).isEmpty();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public synchronized ClasspathStore update(String name, String newContents) {
        if (newContents == null) {
            this.cache.remove(name);
        } else {
            this.cache.put(name, newContents);
        }
        super.update(name, newContents);
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @FluentSetters
    public static class Builder
    extends ConfigStore.Builder {
        protected Builder() {
        }

        protected Builder(ClasspathStore copyFrom) {
            super(copyFrom);
            this.type(copyFrom.getClass());
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public ClasspathStore build() {
            return this.build(ClasspathStore.class);
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }
    }
}

