/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.juneau.common.internal.AsciiSet;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;

public class ConfigMapEntry {
    final String rawLine;
    final String key;
    final String value;
    final String comment;
    final String modifiers;
    final List<String> preLines;
    static final ConfigMapEntry NULL = new ConfigMapEntry(null, null, null, null, null);
    private static final AsciiSet REPLACE_CHARS = AsciiSet.create("\\#");

    ConfigMapEntry(String line, List<String> preLines) {
        this.rawLine = line;
        int i = line.indexOf(61);
        String key = line.substring(0, i).trim();
        int m1 = key.indexOf(60);
        int m2 = key.indexOf(62);
        this.modifiers = StringUtils.nullIfEmpty(m1 > -1 && m2 > m1 ? key.substring(m1 + 1, m2) : null);
        this.key = m1 == -1 ? key : key.substring(0, m1);
        line = line.substring(i + 1);
        i = line.indexOf(35);
        if (i != -1) {
            String[] l2 = StringUtils.split(line, '#', 2);
            line = l2[0];
            this.comment = l2.length == 2 ? l2[1].trim() : null;
        } else {
            this.comment = null;
        }
        this.value = StringUtils.replaceUnicodeSequences(line.trim());
        this.preLines = preLines == null ? CollectionUtils.emptyList() : CollectionUtils.unmodifiable(CollectionUtils.copyOf(preLines));
    }

    ConfigMapEntry(String key, String value, String modifiers, String comment, List<String> preLines) {
        this.rawLine = null;
        this.key = key;
        this.value = value;
        this.comment = comment;
        this.modifiers = modifiers;
        this.preLines = preLines == null ? CollectionUtils.emptyList() : CollectionUtils.unmodifiable(CollectionUtils.copyOf(preLines));
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getPreLines() {
        return this.preLines;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    Writer writeTo(Writer w) throws IOException {
        if (this.value == null) {
            return w;
        }
        for (String pl : this.preLines) {
            w.append(pl).append('\n');
        }
        if (this.rawLine != null) {
            for (int i = 0; i < this.rawLine.length(); ++i) {
                char c = this.rawLine.charAt(i);
                if (c == '\n') {
                    w.append('\n').append('\t');
                    continue;
                }
                if (c == '\r') continue;
                w.append(c);
            }
            w.append('\n');
        } else {
            w.append(this.key);
            if (this.modifiers != null) {
                w.append('<').append(new String(this.modifiers)).append('>');
            }
            w.append(" = ");
            String val = this.value;
            for (int i = 0; i < val.length(); ++i) {
                char c = val.charAt(i);
                if (c == '\n') {
                    w.append('\n').append('\t');
                    continue;
                }
                if (c == '\r') continue;
                if (REPLACE_CHARS.contains(c) || Character.isISOControl(c) && c != '\n' && c != '\r' && c != '\t') {
                    w.append(StringUtils.unicodeSequence(c));
                    continue;
                }
                w.append(c);
            }
            if (StringUtils.isNotEmpty(this.comment)) {
                w.append(" # ").append(this.comment);
            }
            w.append('\n');
        }
        return w;
    }
}

