/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Annotation;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.reflect.MethodInfo;

public class InvalidAnnotationException
extends BasicRuntimeException {
    private static final long serialVersionUID = 1L;

    public InvalidAnnotationException(String message, Object ... args) {
        super(message, args);
    }

    @SafeVarargs
    public static void assertNoInvalidAnnotations(MethodInfo onMethod, Class<? extends Annotation> ... types) throws InvalidAnnotationException {
        Annotation a = onMethod.getAnyAnnotation(types);
        if (a != null) {
            throw new InvalidAnnotationException("@{0} annotation cannot be used in a @{1} bean.  Method=''{2}''", a.getClass().getSimpleName(), onMethod.getDeclaringClass().getSimpleName(), onMethod);
        }
    }
}

