/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.Writer;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.UriResolver;
import org.apache.juneau.common.internal.AsciiSet;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.uon.UonSerializerSession;
import org.apache.juneau.uon.UonUtils;

public final class UonWriter
extends SerializerWriter {
    private final UonSerializerSession session;
    private final boolean encodeChars;
    private final boolean plainTextParams;
    private final char quoteChar;
    private static final AsciiSet unencodedChars = AsciiSet.create().ranges(new String[]{"a-z", "A-Z", "0-9"}).chars(";/?:@-_.!*'$(),~=").build();
    private static final AsciiSet unencodedCharsAttrName = AsciiSet.create().ranges(new String[]{"a-z", "A-Z", "0-9"}).chars(";/?:@-_.!*'$(),~").build();
    private static final AsciiSet escapedChars = AsciiSet.create((String)"~'");
    private static final AsciiSet noChars = AsciiSet.create((String)"");
    private static char[] hexArray = "0123456789ABCDEF".toCharArray();

    protected UonWriter(UonSerializerSession session, Writer out, boolean useWhitespace, int maxIndent, boolean encodeChars, boolean trimStrings, boolean plainTextParams, char quoteChar, UriResolver uriResolver) {
        super(out, useWhitespace, maxIndent, trimStrings, quoteChar, uriResolver);
        this.session = session;
        this.encodeChars = encodeChars;
        this.plainTextParams = plainTextParams;
        this.quoteChar = quoteChar;
    }

    public UonWriter appendObject(Object o, boolean isTopAttrName) {
        AsciiSet esc;
        if (o instanceof Boolean) {
            return this.appendBoolean(o);
        }
        if (o instanceof Number) {
            return this.appendNumber(o);
        }
        if (o == null) {
            return this.append("null");
        }
        String s = this.session.toString(o);
        boolean needsQuotes = !this.plainTextParams && UonUtils.needsQuotes(s);
        AsciiSet unenc = isTopAttrName ? unencodedCharsAttrName : unencodedChars;
        AsciiSet asciiSet = esc = this.plainTextParams ? noChars : escapedChars;
        if (needsQuotes) {
            this.w(this.quoteChar);
        }
        for (int i = 0; i < s.length(); ++i) {
            int p2;
            int p1;
            char c = s.charAt(i);
            if (esc.contains(c)) {
                this.w('~');
            }
            if (!this.encodeChars || unenc.contains(c)) {
                this.w(c);
                continue;
            }
            if (c == ' ') {
                this.w('+');
                continue;
            }
            int p = s.codePointAt(i);
            if (p < 128) {
                this.appendHex(p);
                continue;
            }
            if (p < 2048) {
                p1 = p >>> 6;
                this.appendHex(p1 + 192).appendHex((p & 0x3F) + 128);
                continue;
            }
            if (p < 65536) {
                p1 = p >>> 6;
                p2 = p1 >>> 6;
                this.appendHex(p2 + 224).appendHex((p1 & 0x3F) + 128).appendHex((p & 0x3F) + 128);
                continue;
            }
            ++i;
            p1 = p >>> 6;
            p2 = p1 >>> 6;
            int p3 = p2 >>> 6;
            this.appendHex(p3 + 240).appendHex((p2 & 0x3F) + 128).appendHex((p1 & 0x3F) + 128).appendHex((p & 0x3F) + 128);
        }
        if (needsQuotes) {
            this.w(this.quoteChar);
        }
        return this;
    }

    protected UonWriter appendBoolean(Object o) {
        this.append(o.toString());
        return this;
    }

    protected UonWriter appendNumber(Object o) {
        this.append(o.toString());
        return this;
    }

    private UonWriter appendHex(int b) {
        if (b > 255) {
            throw new BasicRuntimeException("Invalid value passed to appendHex.  Must be in the range 0-255.  Value={0}", b);
        }
        this.w('%').w(hexArray[b >>> 4]).w(hexArray[b & 0xF]);
        return this;
    }

    @Override
    public SerializerWriter appendUri(Object uri) {
        return this.appendObject(this.uriResolver.resolve(uri), false);
    }

    @Override
    public UonWriter cr(int depth) {
        super.cr(depth);
        return this;
    }

    @Override
    public UonWriter cre(int depth) {
        super.cre(depth);
        return this;
    }

    @Override
    public UonWriter appendln(int indent, String text) {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public UonWriter appendln(String text) {
        super.appendln(text);
        return this;
    }

    @Override
    public UonWriter append(int indent, String text) {
        super.append(indent, text);
        return this;
    }

    @Override
    public UonWriter append(int indent, char c) {
        super.append(indent, c);
        return this;
    }

    @Override
    public UonWriter q() {
        super.q();
        return this;
    }

    @Override
    public UonWriter i(int indent) {
        super.i(indent);
        return this;
    }

    @Override
    public UonWriter nl(int indent) {
        super.nl(indent);
        return this;
    }

    @Override
    public UonWriter append(Object text) {
        super.append(text);
        return this;
    }

    @Override
    public UonWriter append(String text) {
        super.append(text);
        return this;
    }

    @Override
    public UonWriter appendIf(boolean b, String text) {
        super.appendIf(b, text);
        return this;
    }

    @Override
    public UonWriter appendIf(boolean b, char c) {
        super.appendIf(b, c);
        return this;
    }

    @Override
    public UonWriter append(char c) {
        super.append(c);
        return this;
    }
}

