/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.BeanContext;
import org.apache.juneau.MediaType;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.ExecutableInfo;

public final class ParserSet {
    private final ConcurrentHashMap<String, ParserMatch> cache = new ConcurrentHashMap();
    private final MediaType[] mediaTypes;
    private final Parser[] mediaTypeParsers;
    final Parser[] entries;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    public ParserSet(Builder builder) {
        this.entries = (Parser[])builder.entries.stream().map(this::build).toArray(Parser[]::new);
        ArrayList<MediaType> lmt = CollectionUtils.list(new MediaType[0]);
        ArrayList<Parser> l = CollectionUtils.list(new Parser[0]);
        for (Parser e : this.entries) {
            e.getMediaTypes().forEach(x -> {
                lmt.add((MediaType)x);
                l.add(e);
            });
        }
        this.mediaTypes = CollectionUtils.array(lmt, MediaType.class);
        this.mediaTypeParsers = CollectionUtils.array(l, Parser.class);
    }

    private Parser build(Object o) {
        if (o instanceof Parser) {
            return (Parser)o;
        }
        return ((Parser.Builder)o).build();
    }

    public Builder copy() {
        return new Builder(this);
    }

    public ParserMatch getParserMatch(String contentTypeHeader) {
        ParserMatch pm = this.cache.get(contentTypeHeader);
        if (pm != null) {
            return pm;
        }
        MediaType ct = MediaType.of(contentTypeHeader);
        int match = ct.match(CollectionUtils.ulist(this.mediaTypes));
        if (match >= 0) {
            pm = new ParserMatch(this.mediaTypes[match], this.mediaTypeParsers[match]);
            this.cache.putIfAbsent(contentTypeHeader, pm);
        }
        return this.cache.get(contentTypeHeader);
    }

    public ParserMatch getParserMatch(MediaType mediaType) {
        return this.getParserMatch(mediaType.toString());
    }

    public Parser getParser(String contentTypeHeader) {
        ParserMatch pm = this.getParserMatch(contentTypeHeader);
        return pm == null ? null : pm.getParser();
    }

    public Parser getParser(MediaType mediaType) {
        ParserMatch pm = this.getParserMatch(mediaType);
        return pm == null ? null : pm.getParser();
    }

    public List<MediaType> getSupportedMediaTypes() {
        return CollectionUtils.ulist(this.mediaTypes);
    }

    public List<Parser> getParsers() {
        return CollectionUtils.ulist(this.entries);
    }

    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<ParserSet> {
        List<Object> entries;
        private BeanContext.Builder bcBuilder;

        protected Builder(BeanStore beanStore) {
            super(ParserSet.class, beanStore);
            this.entries = CollectionUtils.list(new Object[0]);
        }

        protected Builder(ParserSet copyFrom) {
            super(copyFrom.getClass(), BeanStore.INSTANCE);
            this.entries = CollectionUtils.list((Object[])copyFrom.entries);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.bcBuilder = copyFrom.bcBuilder == null ? null : copyFrom.bcBuilder.copy();
            this.entries = CollectionUtils.list(new Object[0]);
            copyFrom.entries.stream().map(this::copyBuilder).forEach((? super T x) -> this.entries.add(x));
        }

        private Object copyBuilder(Object o) {
            if (o instanceof Parser.Builder) {
                Parser.Builder x = (Parser.Builder)o;
                Parser.Builder x2 = x.copy();
                if (ObjectUtils.ne(x.getClass(), x2.getClass())) {
                    throw new BasicRuntimeException("Copy method not implemented on class {0}", x.getClass().getName());
                }
                x = x2;
                if (this.bcBuilder != null) {
                    x.beanContext(this.bcBuilder);
                }
                return x;
            }
            return o;
        }

        @Override
        protected ParserSet buildDefault() {
            return new ParserSet(this);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder beanContext(BeanContext.Builder value) {
            this.bcBuilder = value;
            this.forEach(x -> x.beanContext(value));
            return this;
        }

        public final Builder beanContext(Consumer<BeanContext.Builder> operation) {
            if (this.bcBuilder != null) {
                operation.accept(this.bcBuilder);
            }
            return this;
        }

        public Builder add(Class<?> ... values) {
            ArrayList<Object> l = CollectionUtils.list(new Object[0]);
            for (Class<?> v : values) {
                if (!v.getSimpleName().equals("NoInherit")) continue;
                this.clear();
            }
            for (Class<?> v : values) {
                if (Parser.class.isAssignableFrom(v)) {
                    l.add(this.createBuilder(v));
                    continue;
                }
                if (v.getSimpleName().equals("NoInherit")) continue;
                throw new BasicRuntimeException("Invalid type passed to ParserSet.Builder.add(): {0}", v.getName());
            }
            this.entries.addAll(0, l);
            return this;
        }

        public Builder set(Class<?> ... values) {
            ArrayList<Object> l = CollectionUtils.list(new Object[0]);
            for (Class<?> v : values) {
                if (v.getSimpleName().equals("Inherit")) {
                    l.addAll(this.entries);
                    continue;
                }
                if (Parser.class.isAssignableFrom(v)) {
                    l.add(this.createBuilder(v));
                    continue;
                }
                throw new BasicRuntimeException("Invalid type passed to ParserGrouup.Builder.set(): {0}", v.getName());
            }
            this.entries = l;
            return this;
        }

        private Object createBuilder(Object o) {
            if (o instanceof Class) {
                ConstructorInfo ci = ClassInfo.of((Class)o).getPublicConstructor(ExecutableInfo::hasNoParams);
                if (ci != null) {
                    return ci.invoke(new Object[0]);
                }
                Parser.Builder b = Parser.createParserBuilder((Class)o);
                if (this.bcBuilder != null) {
                    b.beanContext(this.bcBuilder);
                }
                o = b;
            }
            return o;
        }

        public Builder add(Parser ... s) {
            CollectionUtils.prependAll(this.entries, (Object[])s);
            return this;
        }

        public Builder clear() {
            this.entries.clear();
            return this;
        }

        public boolean canApply(AnnotationWorkList work) {
            for (Object o : this.entries) {
                if (!(o instanceof Parser.Builder) || !((Parser.Builder)o).canApply(work)) continue;
                return true;
            }
            return false;
        }

        public Builder apply(AnnotationWorkList work) {
            return this.forEach(x -> x.apply(work));
        }

        public Builder forEach(Consumer<Parser.Builder> action) {
            this.builders(Parser.Builder.class).forEach(action);
            return this;
        }

        public Builder forEachRP(Consumer<ReaderParser.Builder> action) {
            return this.forEach(ReaderParser.Builder.class, action);
        }

        public Builder forEachISP(Consumer<InputStreamParser.Builder> action) {
            return this.forEach(InputStreamParser.Builder.class, action);
        }

        public <B extends Parser.Builder> Builder forEach(Class<B> type, Consumer<B> action) {
            this.builders(type).forEach(action);
            return this;
        }

        public List<Object> inner() {
            return this.entries;
        }

        private <T extends Parser.Builder> Stream<T> builders(Class<T> type) {
            return this.entries.stream().filter(x -> type.isInstance(x)).map(x -> (Parser.Builder)type.cast(x));
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        public String toString() {
            return this.entries.stream().map(this::toString).collect(Collectors.joining(",", "[", "]"));
        }

        private String toString(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof Parser.Builder) {
                return "builder:" + o.getClass().getName();
            }
            return "parser:" + o.getClass().getName();
        }
    }

    public static abstract class NoInherit
    extends Parser {
        protected NoInherit(Parser.Builder builder) {
            super(builder);
        }
    }

    public static abstract class Inherit
    extends Parser {
        protected Inherit(Parser.Builder builder) {
            super(builder);
        }
    }
}

