/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.objecttools.ObjectRest;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.swap.ObjectSwap;

public class JsonMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final JsonMap EMPTY_MAP = new JsonMap(){
        private static final long serialVersionUID = 1L;

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptyMap().entrySet();
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptyMap().keySet();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptyMap().values();
        }
    };
    private transient BeanSession session;
    private Map<String, Object> inner;
    private transient ObjectRest objectRest;
    private transient Predicate<Object> valueFilter = x -> true;

    public static JsonMap create() {
        return new JsonMap();
    }

    public static JsonMap filteredMap() {
        return JsonMap.create().filtered();
    }

    public static JsonMap of(Map<?, ?> values) {
        return values == null ? null : new JsonMap(values);
    }

    public static JsonMap ofJson(CharSequence json) throws ParseException {
        return json == null ? null : new JsonMap(json);
    }

    public static JsonMap ofText(CharSequence in, Parser p) throws ParseException {
        return in == null ? null : new JsonMap(in, p);
    }

    public static JsonMap ofJson(Reader json) throws ParseException {
        return json == null ? null : new JsonMap(json);
    }

    public static JsonMap ofText(Reader in, Parser p) throws ParseException {
        return in == null ? null : new JsonMap(in);
    }

    public static JsonMap of(Object ... keyValuePairs) {
        return new JsonMap(keyValuePairs);
    }

    public static JsonMap filteredMap(Object ... keyValuePairs) {
        return new JsonMap(keyValuePairs).filtered();
    }

    public JsonMap() {
    }

    public JsonMap(BeanSession session) {
        this.session = session;
    }

    public JsonMap(Map<?, ?> in) {
        this();
        if (in != null) {
            in.forEach((k, v) -> this.put(k.toString(), v));
        }
    }

    public JsonMap(CharSequence json) throws ParseException {
        this(json, (Parser)JsonParser.DEFAULT);
    }

    public JsonMap(CharSequence in, Parser p) throws ParseException {
        this(p == null ? BeanContext.DEFAULT_SESSION : p.getBeanContext().getSession());
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        if (!StringUtils.isEmpty((CharSequence)in)) {
            p.parseIntoMap(in, this, this.bs().string(), this.bs().object());
        }
    }

    public JsonMap(Reader json) throws ParseException {
        this.parse(json, JsonParser.DEFAULT);
    }

    public JsonMap(Reader in, Parser p) throws ParseException {
        this(p == null ? BeanContext.DEFAULT_SESSION : p.getBeanContext().getSession());
        this.parse(in, p);
    }

    public JsonMap(Object ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of parameters passed into JsonMap(Object...)");
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            this.put(StringUtils.stringify((Object)keyValuePairs[i]), keyValuePairs[i + 1]);
        }
    }

    public JsonMap inner(Map<String, Object> inner) {
        this.inner = inner;
        return this;
    }

    public JsonMap session(BeanSession session) {
        this.session = session;
        return this;
    }

    public JsonMap append(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public JsonMap append(Map<String, Object> values) {
        if (values != null) {
            super.putAll(values);
        }
        return this;
    }

    public JsonMap appendIf(boolean flag, String key, Object value) {
        if (flag) {
            this.append(key, value);
        }
        return this;
    }

    public <T> JsonMap appendIf(Predicate<T> test, String key, T value) {
        return this.appendIf(ConsumerUtils.test(test, value), key, value);
    }

    @SafeVarargs
    public final <T> JsonMap appendFirst(Predicate<T> test, String key, T ... values) {
        for (T v : values) {
            if (!ConsumerUtils.test(test, v)) continue;
            return this.append(key, v);
        }
        return this;
    }

    public JsonMap appendIfAbsent(String key, Object value) {
        return this.appendIfAbsentIf(x -> true, key, value);
    }

    public <T> JsonMap appendIfAbsentIf(Predicate<T> predicate, String key, T value) {
        Object o = this.get(key);
        if (o == null && predicate.test(value)) {
            this.put(key, value);
        }
        return this;
    }

    public JsonMap filtered() {
        return this.filtered(x -> !(x == null || x instanceof Boolean && x.equals(false) || x instanceof Number && ((Number)x).intValue() == -1 || x.getClass().isArray() && Array.getLength(x) == 0 || x instanceof Map && ((Map)x).isEmpty() || x instanceof Collection && ((Collection)x).isEmpty()));
    }

    public JsonMap filtered(Predicate<Object> value) {
        this.valueFilter = value;
        return this;
    }

    public <T> T get(String key, Class<T> type) {
        return this.getWithDefault(key, null, type);
    }

    public <T> T get(String key, Type type, Type ... args) {
        return this.getWithDefault(key, null, type, args);
    }

    public Object getWithDefault(String key, Object def) {
        Object o = this.get(key);
        return o == null ? def : o;
    }

    public <T> T getWithDefault(String key, T def, Class<T> type) {
        return this.getWithDefault(key, def, type, new Type[0]);
    }

    public <T> T getWithDefault(String key, T def, Type type, Type ... args) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        Object t = this.bs().convertToType(o, type, args);
        return t == null ? def : t;
    }

    public String findKeyIgnoreCase(String key) {
        for (String k : this.keySet()) {
            if (!key.equalsIgnoreCase(k)) continue;
            return k;
        }
        return null;
    }

    public <T> T getSwapped(String key, ObjectSwap<T, ?> objectSwap) throws ParseException {
        try {
            Object o = super.get(key);
            if (o == null) {
                return null;
            }
            ObjectSwap<T, ?> swap = objectSwap;
            return swap.unswap(this.bs(), o, null);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public Object find(String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return this.get(key);
        }
        return null;
    }

    public <T> T find(Class<T> type, String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return this.get(key, type);
        }
        return null;
    }

    public String getString(String key) {
        return this.get(key, String.class);
    }

    public String[] getStringArray(String key) {
        return this.getStringArray(key, null);
    }

    public String[] getStringArray(String key, String[] def) {
        Object s = this.get(key, Object.class);
        if (s == null) {
            return def;
        }
        String[] r = null;
        r = s instanceof Collection ? ArrayUtils.toStringArray((Collection)s) : (s instanceof String[] ? (String[])s : (s instanceof Object[] ? ArrayUtils.toStringArray(CollectionUtils.alist((Object[])s)) : StringUtils.split((String)StringUtils.stringify((Object)s))));
        return r.length == 0 ? def : r;
    }

    public String getString(String key, String defVal) {
        return this.getWithDefault(key, defVal, String.class);
    }

    public Integer getInt(String key) {
        return this.get(key, Integer.class);
    }

    public Integer getInt(String key, Integer defVal) {
        return this.getWithDefault(key, defVal, Integer.class);
    }

    public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    public Long getLong(String key, Long defVal) {
        return this.getWithDefault(key, defVal, Long.class);
    }

    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    public Boolean getBoolean(String key, Boolean defVal) {
        return this.getWithDefault(key, defVal, Boolean.class);
    }

    public JsonMap getMap(String key) {
        return this.get(key, JsonMap.class);
    }

    public JsonMap getMap(String key, JsonMap defVal) {
        return this.getWithDefault(key, defVal, JsonMap.class);
    }

    public JsonMap getMap(String key, boolean createIfNotExists) {
        JsonMap m = this.getWithDefault(key, null, JsonMap.class);
        if (m == null && createIfNotExists) {
            m = new JsonMap();
            this.put(key, (Object)m);
        }
        return m;
    }

    public <K, V> Map<K, V> getMap(String key, Class<K> keyType, Class<V> valType, Map<K, V> def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        return (Map)this.bs().convertToType(o, (Type)((Object)Map.class), keyType, valType);
    }

    public JsonList getList(String key) {
        return this.get(key, JsonList.class);
    }

    public JsonList getList(String key, JsonList defVal) {
        return this.getWithDefault(key, defVal, JsonList.class);
    }

    public JsonList getList(String key, boolean createIfNotExists) {
        JsonList m = this.getWithDefault(key, null, JsonList.class);
        if (m == null && createIfNotExists) {
            m = new JsonList();
            this.put(key, (Object)m);
        }
        return m;
    }

    public <E> List<E> getList(String key, Class<E> elementType, List<E> def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        return (List)this.bs().convertToType(o, (Type)((Object)List.class), elementType);
    }

    public String findString(String ... keys) {
        return this.find(String.class, keys);
    }

    public Integer findInt(String ... keys) {
        return this.find(Integer.class, keys);
    }

    public Long findLong(String ... keys) {
        return this.find(Long.class, keys);
    }

    public Boolean findBoolean(String ... keys) {
        return this.find(Boolean.class, keys);
    }

    public JsonMap findMap(String ... keys) {
        return this.find(JsonMap.class, keys);
    }

    public JsonList findList(String ... keys) {
        return this.find(JsonList.class, keys);
    }

    public String getFirstKey() {
        return this.isEmpty() ? null : this.keySet().iterator().next();
    }

    public ClassMeta<?> getClassMeta(String key) {
        return this.bs().getClassMetaForObject(this.get(key));
    }

    public <T> T removeWithDefault(String key, T defVal, Class<T> type) {
        T t = this.getWithDefault(key, defVal, type);
        this.remove(key);
        return t;
    }

    public String removeString(String key) {
        return this.removeString(key, null);
    }

    public String removeString(String key, String def) {
        return this.removeWithDefault(key, def, String.class);
    }

    public Integer removeInt(String key) {
        return this.removeInt(key, null);
    }

    public Integer removeInt(String key, Integer def) {
        return this.removeWithDefault(key, def, Integer.class);
    }

    public Boolean removeBoolean(String key) {
        return this.removeBoolean(key, null);
    }

    public Boolean removeBoolean(String key, Boolean def) {
        return this.removeWithDefault(key, def, Boolean.class);
    }

    public void removeAll(Collection<String> keys) {
        keys.forEach(this::remove);
    }

    public void removeAll(String ... keys) {
        for (String k : keys) {
            this.remove(k);
        }
    }

    public JsonMap keepAll(String ... keys) {
        Iterator<String> i = this.keySet().iterator();
        while (i.hasNext()) {
            boolean remove = true;
            String key = i.next();
            for (String k : keys) {
                if (!k.equals(key)) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            i.remove();
        }
        return this;
    }

    public boolean containsKeyNotEmpty(String key) {
        Object val = this.get(key);
        if (val == null) {
            return false;
        }
        if (val instanceof CharSequence) {
            return !StringUtils.isEmpty((CharSequence)((CharSequence)val));
        }
        return false;
    }

    public boolean containsOuterKey(Object key) {
        return super.containsKey(key);
    }

    public JsonMap include(String ... keys) {
        JsonMap m2 = new JsonMap();
        this.forEach((k, v) -> {
            for (String kk : keys) {
                if (!kk.equals(k)) continue;
                m2.put(kk, v);
            }
        });
        return m2;
    }

    public JsonMap exclude(String ... keys) {
        JsonMap m2 = new JsonMap();
        this.forEach((k, v) -> {
            boolean exclude = false;
            for (String kk : keys) {
                if (!kk.equals(k)) continue;
                exclude = true;
            }
            if (!exclude) {
                m2.put((String)k, v);
            }
        });
        return m2;
    }

    public <T> T cast(Class<T> type) {
        ClassMeta<T> c;
        BeanSession bs = this.bs();
        ClassMeta<T> c2 = bs.getClassMeta(type);
        String typePropertyName = bs.getBeanTypePropertyName(c2);
        ClassMeta<?> c1 = bs.getBeanRegistry().getClassMeta((String)this.get(typePropertyName));
        ClassMeta<Object> classMeta = c = c1 == null ? c2 : this.narrowClassMeta(c1, c2);
        if (c.isObject()) {
            return (T)this;
        }
        return this.cast2(c);
    }

    public <T> T cast(ClassMeta<T> cm) {
        BeanSession bs = this.bs();
        ClassMeta<?> c1 = bs.getBeanRegistry().getClassMeta((String)this.get(bs.getBeanTypePropertyName(cm)));
        ClassMeta<?> c = this.narrowClassMeta(c1, cm);
        return (T)this.cast2(c);
    }

    public <T> T getAt(String path, Class<T> type) {
        return this.getObjectRest().get(path, type);
    }

    public <T> T getAt(String path, Type type, Type ... args) {
        return this.getObjectRest().get(path, type, args);
    }

    public Object putAt(String path, Object o) {
        return this.getObjectRest().put(path, o);
    }

    public Object postAt(String path, Object o) {
        return this.getObjectRest().post(path, o);
    }

    public Object deleteAt(String path) {
        return this.getObjectRest().delete(path);
    }

    @Override
    public Object put(String key, Object value) {
        if (this.valueFilter.test(value)) {
            super.put(key, value);
        }
        return null;
    }

    public BeanSession getBeanSession() {
        return this.session;
    }

    public JsonMap setBeanSession(BeanSession value) {
        this.session = value;
        return this;
    }

    public void putJson(String key, String json) throws ParseException {
        this.put(key, JsonParser.DEFAULT.parse(json, Object.class));
    }

    public String asString(WriterSerializer serializer) {
        return serializer.toString(this);
    }

    public String asString() {
        if (Json5Serializer.DEFAULT == null) {
            return StringUtils.stringify((Object)this);
        }
        return Json5Serializer.DEFAULT.toString(this);
    }

    public String asReadableString() {
        if (Json5Serializer.DEFAULT_READABLE == null) {
            return StringUtils.stringify((Object)this);
        }
        return Json5Serializer.DEFAULT_READABLE.toString(this);
    }

    public JsonMap writeTo(Writer w) throws IOException, SerializeException {
        JsonSerializer.DEFAULT.serialize(this, w);
        return this;
    }

    public boolean isUnmodifiable() {
        return false;
    }

    public JsonMap modifiable() {
        if (this.isUnmodifiable()) {
            return new JsonMap((Map<?, ?>)this);
        }
        return this;
    }

    public JsonMap unmodifiable() {
        if (this instanceof UnmodifiableJsonMap) {
            return this;
        }
        return new UnmodifiableJsonMap(this);
    }

    private BeanSession bs() {
        if (this.session == null) {
            this.session = BeanContext.DEFAULT_SESSION;
        }
        return this.session;
    }

    private ObjectRest getObjectRest() {
        if (this.objectRest == null) {
            this.objectRest = new ObjectRest(this);
        }
        return this.objectRest;
    }

    private ClassMeta<?> narrowClassMeta(ClassMeta<?> c1, ClassMeta<?> c2) {
        if (c1 == null) {
            return c2;
        }
        ClassMeta<?> c = JsonMap.getNarrowedClassMeta(c1, c2);
        if (c1.isMap()) {
            ClassMeta<?> k = JsonMap.getNarrowedClassMeta(c1.getKeyType(), c2.getKeyType());
            ClassMeta<?> v = JsonMap.getNarrowedClassMeta(c1.getValueType(), c2.getValueType());
            return this.bs().getClassMeta(c.getInnerClass(), k, v);
        }
        if (c1.isCollection()) {
            ClassMeta<?> e = JsonMap.getNarrowedClassMeta(c1.getElementType(), c2.getElementType());
            return this.bs().getClassMeta(c.getInnerClass(), e);
        }
        return c;
    }

    private static ClassMeta<?> getNarrowedClassMeta(ClassMeta<?> c1, ClassMeta<?> c2) {
        if (c2 == null || c2.getInfo().isParentOf(c1.getInnerClass())) {
            return c1;
        }
        return c2;
    }

    private <T> T cast2(ClassMeta<T> cm) {
        BeanSession bs = this.bs();
        try {
            Object value = this.get("value");
            if (cm.isMap()) {
                Map<String, Object> m2 = cm.canCreateNewInstance() ? (Map)cm.newInstance() : new JsonMap(bs);
                ClassMeta<?> kType = cm.getKeyType();
                ClassMeta<?> vType = cm.getValueType();
                this.forEach((k, v) -> {
                    if (!k.equals(bs.getBeanTypePropertyName(cm))) {
                        if (v instanceof JsonMap) {
                            v = ((JsonMap)v).cast(vType);
                        }
                        String k2 = kType.isString() ? k : bs.convertToType(k, kType);
                        v = vType.isObject() ? v : bs.convertToType(v, vType);
                        m2.put(k2, v);
                    }
                });
                return (T)m2;
            }
            if (cm.isBean()) {
                BeanMap bm = bs.newBeanMap(cm.getInnerClass());
                this.forEach((k, v) -> {
                    if (!k.equals(bs.getBeanTypePropertyName(cm))) {
                        if (v instanceof JsonMap) {
                            v = ((JsonMap)v).cast(bm.getProperty((String)k).getMeta().getClassMeta());
                        }
                        bm.put((String)k, v);
                    }
                });
                return bm.getBean();
            }
            if (cm.isCollectionOrArray()) {
                List items = (List)this.get("items");
                return bs.convertToType((Object)items, cm);
            }
            if (value != null) {
                return bs.convertToType(value, cm);
            }
        }
        catch (Exception e) {
            throw new BeanRuntimeException((Throwable)e, cm.getInnerClass(), "Error occurred attempting to cast to an object of type ''{0}''", cm.getInnerClass().getName());
        }
        throw new BeanRuntimeException(cm.getInnerClass(), "Cannot convert to class type ''{0}''.  Only beans and maps can be converted using this method.", cm.getInnerClass().getName());
    }

    private void parse(Reader r, Parser p) throws ParseException {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        p.parseIntoMap(r, this, this.bs().string(), this.bs().object());
    }

    @Override
    public Object get(Object key) {
        Object o = super.get(key);
        if (o == null && this.inner != null) {
            o = this.inner.get(key);
        }
        return o;
    }

    @Override
    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        if (this.inner != null) {
            return this.inner.containsKey(key);
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        if (this.inner == null) {
            return super.keySet();
        }
        LinkedHashSet<String> s = CollectionUtils.set(new String[0]);
        s.addAll(this.inner.keySet());
        s.addAll(super.keySet());
        return s;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.inner == null) {
            return super.entrySet();
        }
        final Set<String> keySet = this.keySet();
        final Iterator<String> keys = keySet.iterator();
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return keys.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        return new Map.Entry<String, Object>(){
                            String key;
                            {
                                this.key = (String)keys.next();
                            }

                            @Override
                            public String getKey() {
                                return this.key;
                            }

                            @Override
                            public Object getValue() {
                                return JsonMap.this.get(this.key);
                            }

                            @Override
                            public Object setValue(Object object) {
                                return JsonMap.this.put(this.key, object);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported on read-only object.");
                    }
                };
            }

            @Override
            public int size() {
                return keySet.size();
            }
        };
    }

    public String asJson() {
        return this.toString();
    }

    @Override
    public String toString() {
        return Json5.of(this);
    }

    private static final class UnmodifiableJsonMap
    extends JsonMap {
        private static final long serialVersionUID = 1L;

        UnmodifiableJsonMap(JsonMap contents) {
            if (contents != null) {
                contents.forEach((x$0, x$1) -> super.put((String)x$0, x$1));
            }
        }

        @Override
        public Object put(String key, Object val) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public boolean isUnmodifiable() {
            return true;
        }
    }
}

