/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Marshalled;
import org.apache.juneau.annotation.TargetedAnnotationTBuilder;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class MarshalledAnnotation {
    public static final Marshalled DEFAULT = MarshalledAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return MarshalledAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return MarshalledAnnotation.create().on(on);
    }

    public static Marshalled copy(Marshalled a, VarResolverSession r) {
        return ((Builder)MarshalledAnnotation.create().example(r.resolve(a.example())).implClass(a.implClass()).on(r.resolve(a.on())).onClass((Class[])a.onClass())).build();
    }

    public static class Builder
    extends TargetedAnnotationTBuilder {
        Class<?> implClass = Void.TYPE;
        String example = "";

        protected Builder() {
            super(Marshalled.class);
        }

        public Marshalled build() {
            return new Impl(this);
        }

        public Builder example(String value) {
            this.example = value;
            return this;
        }

        public Builder implClass(Class<?> value) {
            this.implClass = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Marshalled[] value();
    }

    public static class Applier
    extends AnnotationApplier<Marshalled, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Marshalled.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Marshalled> ai, BeanContext.Builder b) {
            Marshalled a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(MarshalledAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Marshalled {
        private final Class<?> implClass;
        private final String example;

        Impl(Builder b) {
            super(b);
            this.example = b.example;
            this.implClass = b.implClass;
            this.postConstruct();
        }

        @Override
        public String example() {
            return this.example;
        }

        @Override
        public Class<?> implClass() {
            return this.implClass;
        }
    }
}

