/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.marshaller.Json5;

@Bean(properties="type,description,name,in,flow,authorizationUrl,tokenUrl,scopes,*")
@FluentSetters
public class SecurityScheme
extends SwaggerElement {
    private static final String[] VALID_TYPES = new String[]{"basic", "apiKey", "oauth2"};
    private String type;
    private String description;
    private String name;
    private String in;
    private String flow;
    private String authorizationUrl;
    private String tokenUrl;
    private Map<String, String> scopes;

    public SecurityScheme() {
    }

    public SecurityScheme(SecurityScheme copyFrom) {
        super(copyFrom);
        this.authorizationUrl = copyFrom.authorizationUrl;
        this.description = copyFrom.description;
        this.flow = copyFrom.flow;
        this.in = copyFrom.in;
        this.name = copyFrom.name;
        this.scopes = CollectionUtils.copyOf(copyFrom.scopes);
        this.tokenUrl = copyFrom.tokenUrl;
        this.type = copyFrom.type;
    }

    public SecurityScheme copy() {
        return new SecurityScheme(this);
    }

    @Override
    protected SecurityScheme strict() {
        super.strict();
        return this;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public SecurityScheme setAuthorizationUrl(String value) {
        this.authorizationUrl = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SecurityScheme setDescription(String value) {
        this.description = value;
        return this;
    }

    public String getFlow() {
        return this.flow;
    }

    public SecurityScheme setFlow(String value) {
        this.flow = value;
        return this;
    }

    public String getIn() {
        return this.in;
    }

    public SecurityScheme setIn(String value) {
        this.in = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public SecurityScheme setName(String value) {
        this.name = value;
        return this;
    }

    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public SecurityScheme setScopes(Map<String, String> value) {
        this.scopes = CollectionUtils.copyOf(value);
        return this;
    }

    public SecurityScheme addScope(String key, String value) {
        this.scopes = CollectionUtils.mapBuilder(this.scopes).sparse().add((Object)key, (Object)value).build();
        return this;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public SecurityScheme setTokenUrl(String value) {
        this.tokenUrl = value;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SecurityScheme setType(String value) {
        if (this.isStrict() && !ArrayUtils.contains((String)value, (String[])VALID_TYPES)) {
            throw new BasicRuntimeException("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", new Object[]{value, Json5.of((Object)VALID_TYPES)});
        }
        this.type = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "authorizationUrl": {
                return (T)ConverterUtils.toType((Object)this.getAuthorizationUrl(), type);
            }
            case "description": {
                return (T)ConverterUtils.toType((Object)this.getDescription(), type);
            }
            case "flow": {
                return (T)ConverterUtils.toType((Object)this.getFlow(), type);
            }
            case "in": {
                return (T)ConverterUtils.toType((Object)this.getIn(), type);
            }
            case "name": {
                return (T)ConverterUtils.toType((Object)this.getName(), type);
            }
            case "scopes": {
                return (T)ConverterUtils.toType(this.getScopes(), type);
            }
            case "tokenUrl": {
                return (T)ConverterUtils.toType((Object)this.getTokenUrl(), type);
            }
            case "type": {
                return (T)ConverterUtils.toType((Object)this.getType(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public SecurityScheme set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "authorizationUrl": {
                return this.setAuthorizationUrl(StringUtils.stringify((Object)value));
            }
            case "description": {
                return this.setDescription(StringUtils.stringify((Object)value));
            }
            case "flow": {
                return this.setFlow(StringUtils.stringify((Object)value));
            }
            case "in": {
                return this.setIn(StringUtils.stringify((Object)value));
            }
            case "name": {
                return this.setName(StringUtils.stringify((Object)value));
            }
            case "scopes": {
                return this.setScopes(CollectionUtils.mapBuilder(String.class, String.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "tokenUrl": {
                return this.setTokenUrl(StringUtils.stringify((Object)value));
            }
            case "type": {
                return this.setType(StringUtils.stringify((Object)value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).addIf(this.authorizationUrl != null, (Object)"authorizationUrl").addIf(this.description != null, (Object)"description").addIf(this.flow != null, (Object)"flow").addIf(this.in != null, (Object)"in").addIf(this.name != null, (Object)"name").addIf(this.scopes != null, (Object)"scopes").addIf(this.tokenUrl != null, (Object)"tokenUrl").addIf(this.type != null, (Object)"type").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }
}

