/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfMetaProvider;
import org.apache.juneau.jena.RdfParserSession;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlMetaProvider;

public class RdfParser
extends ReaderParser
implements RdfMetaProvider {
    final boolean trimWhitespace;
    final boolean looseCollections;
    final String language;
    final Namespace juneauNs;
    final Namespace juneauBpNs;
    final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaSettings;
    private final Map<ClassMeta<?>, RdfClassMeta> rdfClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, RdfBeanMeta> rdfBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, RdfBeanPropertyMeta> rdfBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, RdfBeanPropertyMeta>();
    private final Map<ClassMeta<?>, XmlClassMeta> xmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, XmlBeanMeta> xmlBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, XmlBeanPropertyMeta> xmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, XmlBeanPropertyMeta>();

    public static Builder create() {
        return new Builder();
    }

    public RdfParser(Builder builder) {
        super((ReaderParser.Builder)builder.consumes(RdfParser.getConsumes(builder)));
        this.trimWhitespace = builder.trimWhitespace;
        this.looseCollections = builder.looseCollections;
        this.language = builder.language;
        this.juneauNs = builder.juneauNs;
        this.juneauBpNs = builder.juneauBpNs;
        this.collectionFormat = builder.collectionFormat;
        this.jenaSettings = new TreeMap<String, Object>(builder.jenaSettings);
    }

    private static String getConsumes(Builder builder) {
        if (builder.getConsumes() != null) {
            return builder.getConsumes();
        }
        switch (builder.language) {
            case "RDF/XML": 
            case "RDF/XML-ABBREV": {
                return "text/xml+rdf";
            }
            case "N-TRIPLE": {
                return "text/n-triple";
            }
            case "N3": {
                return "text/n3";
            }
            case "N3-PP": {
                return "text/n3-pp";
            }
            case "N3-PLAIN": {
                return "text/n3-plain";
            }
            case "N3-TRIPLES": {
                return "text/n3-triples";
            }
            case "TURTLE": {
                return "text/turtle";
            }
        }
        return "text/xml+rdf";
    }

    public Builder copy() {
        return new Builder(this);
    }

    public RdfParserSession.Builder createSession() {
        return RdfParserSession.create(this);
    }

    public RdfParserSession getSession() {
        return this.createSession().build();
    }

    @Override
    public RdfClassMeta getRdfClassMeta(ClassMeta<?> cm) {
        RdfClassMeta m = this.rdfClassMetas.get(cm);
        if (m == null) {
            m = new RdfClassMeta(cm, this);
            this.rdfClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public RdfBeanMeta getRdfBeanMeta(BeanMeta<?> bm) {
        RdfBeanMeta m = this.rdfBeanMetas.get(bm);
        if (m == null) {
            m = new RdfBeanMeta(bm, this);
            this.rdfBeanMetas.put(bm, m);
        }
        return m;
    }

    @Override
    public RdfBeanPropertyMeta getRdfBeanPropertyMeta(BeanPropertyMeta bpm) {
        RdfBeanPropertyMeta m = this.rdfBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new RdfBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.rdfBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    public XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        XmlClassMeta m = this.xmlClassMetas.get(cm);
        if (m == null) {
            m = new XmlClassMeta(cm, (XmlMetaProvider)this);
            this.xmlClassMetas.put(cm, m);
        }
        return m;
    }

    public XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        XmlBeanMeta m = this.xmlBeanMetas.get(bm);
        if (m == null) {
            m = new XmlBeanMeta(bm, (XmlMetaProvider)this);
            this.xmlBeanMetas.put(bm, m);
        }
        return m;
    }

    public XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        XmlBeanPropertyMeta m = this.xmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new XmlBeanPropertyMeta(bpm.getDelegateFor(), (XmlMetaProvider)this);
            this.xmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected final Namespace getJuneauBpNs() {
        return this.juneauBpNs;
    }

    protected final Namespace getJuneauNs() {
        return this.juneauNs;
    }

    protected final String getLanguage() {
        return this.language;
    }

    protected final boolean isLooseCollections() {
        return this.looseCollections;
    }

    protected final Map<String, Object> getJenaSettings() {
        return this.jenaSettings;
    }

    protected final boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap().append("trimWhitespace", (Object)this.trimWhitespace).append("looseCollections", (Object)this.looseCollections).append("language", (Object)this.language).append("juneauNs", (Object)this.juneauNs).append("juneauBpNs", (Object)this.juneauBpNs).append("collectionFormat", (Object)this.collectionFormat);
    }

    @FluentSetters
    public static class Builder
    extends ReaderParser.Builder {
        private static final Cache<HashKey, RdfParser> CACHE = Cache.of(HashKey.class, RdfParser.class).build();
        private static final Namespace DEFAULT_JUNEAU_NS = Namespace.of((String)"j", (String)"http://www.apache.org/juneau/");
        private static final Namespace DEFAULT_JUNEAUBP_NS = Namespace.of((String)"jp", (String)"http://www.apache.org/juneaubp/");
        boolean trimWhitespace;
        boolean looseCollections;
        String language;
        Namespace juneauNs;
        Namespace juneauBpNs;
        RdfCollectionFormat collectionFormat;
        Map<String, Object> jenaSettings = new TreeMap<String, Object>();

        protected Builder() {
            this.trimWhitespace = (Boolean)this.env("Rdf.trimWhitespace", false);
            this.looseCollections = (Boolean)this.env("Rdf.looseCollections", false);
            this.language = (String)this.env("Rdf.language", "RDF/XML-ABBREV");
            this.collectionFormat = (RdfCollectionFormat)((Object)this.env("Rdf.collectionFormat", (Object)RdfCollectionFormat.DEFAULT));
            this.juneauNs = DEFAULT_JUNEAU_NS;
            this.juneauBpNs = DEFAULT_JUNEAUBP_NS;
            this.jenaSettings = new TreeMap<String, Object>();
        }

        protected Builder(RdfParser copyFrom) {
            super((ReaderParser)copyFrom);
            this.trimWhitespace = copyFrom.trimWhitespace;
            this.looseCollections = copyFrom.looseCollections;
            this.language = copyFrom.language;
            this.collectionFormat = copyFrom.collectionFormat;
            this.juneauNs = copyFrom.juneauNs;
            this.juneauBpNs = copyFrom.juneauBpNs;
            this.jenaSettings = new TreeMap<String, Object>(copyFrom.jenaSettings);
        }

        protected Builder(Builder copyFrom) {
            super((ReaderParser.Builder)copyFrom);
            this.trimWhitespace = copyFrom.trimWhitespace;
            this.looseCollections = copyFrom.looseCollections;
            this.language = copyFrom.language;
            this.collectionFormat = copyFrom.collectionFormat;
            this.juneauNs = copyFrom.juneauNs;
            this.juneauBpNs = copyFrom.juneauBpNs;
            this.jenaSettings = new TreeMap<String, Object>(copyFrom.jenaSettings);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public RdfParser build() {
            return (RdfParser)this.cache((Cache)CACHE).build(RdfParser.class);
        }

        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{super.hashKey(), this.trimWhitespace, this.looseCollections, this.language, this.collectionFormat, this.juneauNs, this.juneauBpNs, this.jenaSettings});
        }

        Builder jena(String key, Object value) {
            this.jenaSettings.put(key, value);
            return this;
        }

        @FluentSetter
        public Builder rdfxml_iriRules(String value) {
            return this.jena("rdfXml.iri-rules", value);
        }

        @FluentSetter
        public Builder rdfxml_errorMode(String value) {
            return this.jena("rdfXml.error-mode", value);
        }

        @FluentSetter
        public Builder rdfxml_embedding() {
            return this.rdfxml_embedding(true);
        }

        @FluentSetter
        public Builder rdfxml_embedding(boolean value) {
            return this.jena("rdfXml.embedding", value);
        }

        @FluentSetter
        public Builder rdfxml_xmlbase(String value) {
            return this.jena("rdfXml.xmlbase", value);
        }

        @FluentSetter
        public Builder rdfxml_longId() {
            return this.rdfxml_longId(true);
        }

        @FluentSetter
        public Builder rdfxml_longId(boolean value) {
            return this.jena("rdfXml.longId", value);
        }

        @FluentSetter
        public Builder rdfxml_allowBadUris() {
            return this.rdfxml_allowBadUris(true);
        }

        @FluentSetter
        public Builder rdfxml_allowBadUris(boolean value) {
            return this.jena("rdfXml.allowBadURIs", value);
        }

        @FluentSetter
        public Builder rdfxml_relativeUris(String value) {
            return this.jena("rdfXml.relativeURIs", value);
        }

        @FluentSetter
        public Builder rdfxml_showXmlDeclaration(String value) {
            return this.jena("rdfXml.showXmlDeclaration", value);
        }

        @FluentSetter
        public Builder rdfxml_disableShowDoctypeDeclaration() {
            return this.rdfxml_disableShowDoctypeDeclaration(true);
        }

        @FluentSetter
        public Builder rdfxml_disableShowDoctypeDeclaration(boolean value) {
            return this.jena("rdfXml.disableShowDoctypeDeclaration", value);
        }

        @FluentSetter
        public Builder rdfxml_tab(int value) {
            return this.jena("rdfXml.tab", value);
        }

        @FluentSetter
        public Builder rdfxml_attributeQuoteChar(char value) {
            return this.jena("rdfXml.attributeQuoteChar", Character.valueOf(value));
        }

        @FluentSetter
        public Builder rdfxml_blockRules(String value) {
            return this.jena("rdfXml.blockRules", value);
        }

        @FluentSetter
        public Builder n3_minGap(int value) {
            return this.jena("n3.minGap", value);
        }

        @FluentSetter
        public Builder n3_disableObjectLists() {
            return this.n3_disableObjectLists(true);
        }

        @FluentSetter
        public Builder n3_disableObjectLists(boolean value) {
            return this.jena("n3.disableObjectLists", value);
        }

        @FluentSetter
        public Builder n3_subjectColumn(int value) {
            return this.jena("n3.subjectColumn", value);
        }

        @FluentSetter
        public Builder n3_propertyColumn(int value) {
            return this.jena("n3.propertyColumn", value);
        }

        @FluentSetter
        public Builder n3_indentProperty(int value) {
            return this.jena("n3.indentProperty", value);
        }

        @FluentSetter
        public Builder n3_widePropertyLen(int value) {
            return this.jena("n3.widePropertyLen", value);
        }

        @FluentSetter
        public Builder n3_disableAbbrevBaseUri() {
            return this.n3_disableAbbrevBaseUri(true);
        }

        @FluentSetter
        public Builder n3_disableAbbrevBaseUri(boolean value) {
            return this.jena("n3.disableAbbrevBaseUri", value);
        }

        @FluentSetter
        public Builder n3_disableUsePropertySymbols() {
            return this.n3_disableUsePropertySymbols(true);
        }

        @FluentSetter
        public Builder n3_disableUsePropertySymbols(boolean value) {
            return this.jena("n3.disableUsePropertySymbols", value);
        }

        @FluentSetter
        public Builder n3_disableUseTripleQuotedStrings() {
            return this.n3_disableUseTripleQuotedStrings(true);
        }

        @FluentSetter
        public Builder n3_disableUseTripleQuotedStrings(boolean value) {
            return this.jena("n3.disableUseTripleQuotedStrings", value);
        }

        @FluentSetter
        public Builder n3_disableUseDoubles() {
            return this.n3_disableUseDoubles(true);
        }

        @FluentSetter
        public Builder n3_disableUseDoubles(boolean value) {
            return this.jena("n3.disableUseDoubles", value);
        }

        @FluentSetter
        public Builder collectionFormat(RdfCollectionFormat value) {
            this.collectionFormat = value;
            return this;
        }

        @FluentSetter
        public Builder juneauBpNs(Namespace value) {
            this.juneauBpNs = value;
            return this;
        }

        @FluentSetter
        public Builder juneauNs(Namespace value) {
            this.juneauNs = value;
            return this;
        }

        @FluentSetter
        public Builder language(String value) {
            this.language = value;
            return this;
        }

        @FluentSetter
        public Builder looseCollections() {
            return this.looseCollections(true);
        }

        @FluentSetter
        public Builder looseCollections(boolean value) {
            this.looseCollections = value;
            return this;
        }

        @FluentSetter
        public Builder n3() {
            return this.language("N3");
        }

        @FluentSetter
        public Builder ntriple() {
            return this.language("N-TRIPLE");
        }

        @FluentSetter
        public Builder trimWhitespace() {
            return this.trimWhitespace(true);
        }

        @FluentSetter
        public Builder trimWhitespace(boolean value) {
            this.trimWhitespace = value;
            return this;
        }

        @FluentSetter
        public Builder turtle() {
            return this.language("TURTLE");
        }

        @FluentSetter
        public Builder xml() {
            return this.language("RDF/XML");
        }

        @FluentSetter
        public Builder xmlabbrev() {
            return this.language("RDF/XML-ABBREV");
        }

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public Builder debug() {
            super.debug();
            return this;
        }

        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor(on, value);
            return this;
        }

        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties(values);
            return this;
        }

        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties(beanClass, properties);
            return this;
        }

        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes(values);
            return this;
        }

        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly(values);
            return this;
        }

        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly(values);
            return this;
        }

        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn(on, (Class[])values);
            return this;
        }

        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example(pojoClass, o);
            return this;
        }

        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example(pojoClass, json);
            return this;
        }

        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters(on);
            return this;
        }

        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass(interfaceClass, implClass);
            return this;
        }

        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses(values);
            return this;
        }

        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass(on, value);
            return this;
        }

        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer(value);
            return this;
        }

        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer(on, value);
            return this;
        }

        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass(on, value);
            return this;
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap(normalClass, swappedClass, swapFunction);
            return this;
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap(normalClass, swappedClass, swapFunction, unswapFunction);
            return this;
        }

        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        public Builder typeName(Class<?> on, String value) {
            super.typeName(on, value);
            return this;
        }

        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName(on, value);
            return this;
        }

        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        public Builder autoCloseStreams() {
            super.autoCloseStreams();
            return this;
        }

        public Builder autoCloseStreams(boolean value) {
            super.autoCloseStreams(value);
            return this;
        }

        public Builder consumes(String value) {
            super.consumes(value);
            return this;
        }

        public Builder debugOutputLines(int value) {
            super.debugOutputLines(value);
            return this;
        }

        public Builder listener(Class<? extends ParserListener> value) {
            super.listener(value);
            return this;
        }

        public Builder strict() {
            super.strict();
            return this;
        }

        public Builder strict(boolean value) {
            super.strict(value);
            return this;
        }

        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        public Builder unbuffered() {
            super.unbuffered();
            return this;
        }

        public Builder unbuffered(boolean value) {
            super.unbuffered(value);
            return this;
        }

        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }
    }
}

