/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.juneau.Value;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;

public class ObjectUtils {
    private static final ConcurrentHashMap<Class<?>, Map<String, MethodInfo>> PROPERTIES_METHODS = new ConcurrentHashMap();

    public static <T> T castOrNull(Object o, Class<T> c) {
        if (c.isInstance(o)) {
            return c.cast(o);
        }
        return null;
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass() == o2.getClass() && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return 0;
    }

    public static final int compare(int i1, int i2) {
        return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
    }

    public static <T, U> boolean eq(T o1, U o2, BiPredicate<T, U> test) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        return test.test(o1, o2);
    }

    public static <T> boolean eq(T o1, T o2) {
        if (ObjectUtils.isArray(o1) && ObjectUtils.isArray(o2)) {
            int l2;
            int l1 = Array.getLength(o1);
            if (l1 != (l2 = Array.getLength(o2))) {
                return false;
            }
            for (int i = 0; i < l1; ++i) {
                if (ObjectUtils.eq(Array.get(o1, i), Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }
        return Objects.equals(o1, o2);
    }

    public static <T> boolean eq(T[] o1, T[] o2) {
        if (o1 == null || o2 == null) {
            return o1 == null && o2 == null;
        }
        if (o1.length != o2.length) {
            return false;
        }
        for (int i = 0; i < o1.length; ++i) {
            if (ObjectUtils.eq(o1[i], o2[i])) continue;
            return false;
        }
        return true;
    }

    public static <T, U> boolean ne(T o1, U o2, BiPredicate<T, U> test) {
        if (o1 == null) {
            return o2 != null;
        }
        if (o2 == null) {
            return true;
        }
        if (o1 == o2) {
            return false;
        }
        return !test.test(o1, o2);
    }

    public static boolean ne(Object o1, Object o2) {
        return !ObjectUtils.eq(o1, o2);
    }

    private static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        while (o instanceof Value) {
            o = ((Value)o).get();
        }
        return o;
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        return o.toString().isEmpty();
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... t) {
        if (t != null) {
            for (T tt : t) {
                if (tt == null) continue;
                return tt;
            }
        }
        return null;
    }

    public static <T> T cast(Class<T> c, Object o) {
        return o != null && c.isInstance(o) ? (T)c.cast(o) : null;
    }

    public static String identity(Object o) {
        if (o instanceof Optional) {
            o = ((Optional)o).orElse(null);
        }
        if (o == null) {
            return null;
        }
        return ClassInfo.of(o).getShortName() + "@" + System.identityHashCode(o);
    }

    public static JsonMap toPropertyMap(Object o) {
        if (o == null) {
            return null;
        }
        Map<String, MethodInfo> methods = PROPERTIES_METHODS.get(o.getClass());
        if (methods == null) {
            ClassInfo ci = ClassInfo.of(o);
            LinkedHashMap<String, MethodInfo> methods2 = new LinkedHashMap<String, MethodInfo>();
            do {
                String cname = ci.getShortName();
                MethodInfo mi = ci.getDeclaredMethod(x -> x.hasName("properties"));
                if (mi == null) continue;
                methods2.put(cname, mi.accessible());
            } while ((ci = ci.getSuperclass()) != null);
            methods = methods2;
            PROPERTIES_METHODS.put(o.getClass(), methods);
        }
        JsonMap m = JsonMap.create().append("id", ObjectUtils.identity(o));
        methods.forEach((k, v) -> m.put((String)k, v.invoke(o, new Object[0])));
        return m;
    }

    public static <T> boolean isNotNull(T value) {
        return value != null;
    }

    public static boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    public static <T extends Number> boolean isNotMinusOne(T value) {
        return value != null && value.intValue() != -1;
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)CharSequence.class.cast(value)).length() > 0;
        }
        if (value instanceof Collection) {
            return !((Collection)Collection.class.cast(value)).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)Map.class.cast(value)).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) > 0;
        }
        return StringUtils.isNotEmpty(StringUtils.stringify(value));
    }
}

