/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

public class BasicUriHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final URI value;
    private final Supplier<URI> supplier;

    public static BasicUriHeader of(String name, String value) {
        return value == null ? null : new BasicUriHeader(name, value);
    }

    public static BasicUriHeader of(String name, URI value) {
        return value == null ? null : new BasicUriHeader(name, value);
    }

    public static BasicUriHeader of(String name, Supplier<URI> value) {
        return value == null ? null : new BasicUriHeader(name, value);
    }

    public BasicUriHeader(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty(value) ? null : URI.create(value);
        this.supplier = null;
    }

    public BasicUriHeader(String name, URI value) {
        super(name, StringUtils.stringify(value));
        this.value = value;
        this.supplier = null;
    }

    public BasicUriHeader(String name, Supplier<URI> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify(this.value());
    }

    public Optional<URI> asUri() {
        return CollectionUtils.optional(this.value());
    }

    public URI toUri() {
        return this.value();
    }

    public URI orElse(URI other) {
        URI x = this.value();
        return x != null ? x : other;
    }

    private URI value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

