/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Example;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMFBuilder;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class ExampleAnnotation {
    public static final Example DEFAULT = ExampleAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return ExampleAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return ExampleAnnotation.create().on(on);
    }

    public static Example copy(Example a, VarResolverSession r) {
        return ((Builder)ExampleAnnotation.create().on(r.resolve(a.on())).onClass((Class[])a.onClass())).value(r.resolve(a.value())).build();
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Example[] value();
    }

    public static class Applier
    extends AnnotationApplier<Example, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Example.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Example> ai, BeanContext.Builder b) {
            Example a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(ExampleAnnotation.copy(a, this.vr()));
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Example {
        private final String value;

        Impl(Builder b) {
            super(b);
            this.value = b.value;
            this.postConstruct();
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    public static class Builder
    extends TargetedAnnotationTMFBuilder {
        String value = "";

        protected Builder() {
            super(Example.class);
        }

        public Example build() {
            return new Impl(this);
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

