/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BasicPropertyNamer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanAnnotation;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.MarshalledAnnotation;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.swap.FunctionalSwap;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.swap.Surrogate;
import org.apache.juneau.swap.SurrogateSwap;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;

public class BeanContext
extends Context {
    private static final String[] DEFAULT_NOTBEAN_PACKAGES = new String[]{"java.lang", "java.lang.annotation", "java.lang.ref", "java.lang.reflect", "java.io", "java.net", "java.nio.*", "java.util.*"};
    private static final Class<?>[] DEFAULT_NOTBEAN_CLASSES = new Class[]{Map.class, Collection.class, Reader.class, Writer.class, InputStream.class, OutputStream.class, Throwable.class};
    public static final BeanContext DEFAULT = BeanContext.create().build();
    public static final BeanContext DEFAULT_SORTED = BeanContext.create().sortProperties().build();
    public static final BeanSession DEFAULT_SESSION = DEFAULT.createSession().unmodifiable().build();
    final boolean beansRequireDefaultConstructor;
    final boolean beansRequireSerializable;
    final boolean beansRequireSettersForGetters;
    final boolean beansRequireSomeProperties;
    final boolean beanMapPutReturnsOldValue;
    final boolean useInterfaceProxies;
    final boolean ignoreUnknownBeanProperties;
    final boolean ignoreUnknownNullBeanProperties;
    final boolean ignoreUnknownEnumValues;
    final boolean ignoreMissingSetters;
    final boolean ignoreTransientFields;
    final boolean ignoreInvocationExceptionsOnGetters;
    final boolean ignoreInvocationExceptionsOnSetters;
    final boolean useJavaBeanIntrospector;
    final boolean useEnumNames;
    final boolean sortProperties;
    final boolean findFluentSetters;
    final Visibility beanConstructorVisibility;
    final Visibility beanClassVisibility;
    final Visibility beanMethodVisibility;
    final Visibility beanFieldVisibility;
    final String typePropertyName;
    final Locale locale;
    final TimeZone timeZone;
    final MediaType mediaType;
    final Class<? extends PropertyNamer> propertyNamer;
    final List<Class<?>> beanDictionary;
    final List<Class<?>> notBeanClasses;
    final List<Object> swaps;
    final List<String> notBeanPackages;
    final HashKey hashKey;
    final Map<Class, ClassMeta> cmCache;
    private final String[] notBeanPackageNames;
    private final String[] notBeanPackagePrefixes;
    private final BeanRegistry beanRegistry;
    private final PropertyNamer propertyNamerBean;
    private final ObjectSwap[] swapArray;
    private final Class<?>[] notBeanClassesArray;
    private final ClassMeta<Object> cmObject;
    private final ClassMeta<String> cmString;
    private final ClassMeta<Class> cmClass;
    private final BeanSession defaultSession;
    private volatile WriterSerializer beanToStringSerializer;

    public static Builder create() {
        return new Builder();
    }

    public BeanContext(Builder builder) {
        super(builder);
        this.hashKey = builder.hashKey();
        this.beanConstructorVisibility = builder.beanConstructorVisibility;
        this.beanClassVisibility = builder.beanClassVisibility;
        this.beanMethodVisibility = builder.beanMethodVisibility;
        this.beanFieldVisibility = builder.beanFieldVisibility;
        this.beansRequireDefaultConstructor = builder.beansRequireDefaultConstructor;
        this.beansRequireSerializable = builder.beansRequireSerializable;
        this.beansRequireSettersForGetters = builder.beansRequireSettersForGetters;
        this.beansRequireSomeProperties = !builder.disableBeansRequireSomeProperties;
        this.beanMapPutReturnsOldValue = builder.beanMapPutReturnsOldValue;
        this.useEnumNames = builder.useEnumNames;
        this.useInterfaceProxies = !builder.disableInterfaceProxies;
        this.ignoreUnknownBeanProperties = builder.ignoreUnknownBeanProperties;
        this.ignoreUnknownNullBeanProperties = !builder.disableIgnoreUnknownNullBeanProperties;
        this.ignoreUnknownEnumValues = builder.ignoreUnknownEnumValues;
        this.ignoreMissingSetters = !builder.disableIgnoreMissingSetters;
        this.ignoreTransientFields = !builder.disableIgnoreTransientFields;
        this.ignoreInvocationExceptionsOnGetters = builder.ignoreInvocationExceptionsOnGetters;
        this.ignoreInvocationExceptionsOnSetters = builder.ignoreInvocationExceptionsOnSetters;
        this.useJavaBeanIntrospector = builder.useJavaBeanIntrospector;
        this.sortProperties = builder.sortProperties;
        this.findFluentSetters = builder.findFluentSetters;
        this.typePropertyName = builder.typePropertyName != null ? builder.typePropertyName : "_type";
        this.locale = builder.locale != null ? builder.locale : Locale.getDefault();
        this.timeZone = builder.timeZone;
        this.mediaType = builder.mediaType;
        this.beanDictionary = CollectionUtils.optional(builder.beanDictionary).map(Collections::unmodifiableList).orElse(CollectionUtils.emptyList());
        this.swaps = CollectionUtils.optional(builder.swaps).map(Collections::unmodifiableList).orElse(CollectionUtils.emptyList());
        this.notBeanClasses = CollectionUtils.optional(builder.notBeanClasses).map(ArrayList::new).map(Collections::unmodifiableList).orElse(CollectionUtils.emptyList());
        this.notBeanPackages = CollectionUtils.optional(builder.notBeanPackages).map(ArrayList::new).map(Collections::unmodifiableList).orElse(CollectionUtils.emptyList());
        this.propertyNamer = builder.propertyNamer != null ? builder.propertyNamer : BasicPropertyNamer.class;
        this.notBeanClassesArray = this.notBeanClasses.isEmpty() ? DEFAULT_NOTBEAN_CLASSES : (Class[])Stream.of(this.notBeanClasses, CollectionUtils.alist(DEFAULT_NOTBEAN_CLASSES)).flatMap(Collection::stream).toArray(Class[]::new);
        String[] _notBeanPackages = this.notBeanPackages.isEmpty() ? DEFAULT_NOTBEAN_PACKAGES : (String[])Stream.of(this.notBeanPackages, CollectionUtils.alist(DEFAULT_NOTBEAN_PACKAGES)).flatMap(Collection::stream).toArray(String[]::new);
        this.notBeanPackageNames = (String[])Stream.of(_notBeanPackages).filter(x -> !x.endsWith(".*")).toArray(String[]::new);
        this.notBeanPackagePrefixes = (String[])Stream.of(_notBeanPackages).filter(x -> x.endsWith(".*")).map(x -> x.substring(0, x.length() - 2)).toArray(String[]::new);
        try {
            this.propertyNamerBean = this.propertyNamer.newInstance();
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
        LinkedList _swaps = new LinkedList();
        this.swaps.forEach(x -> {
            if (x instanceof ObjectSwap) {
                _swaps.add((ObjectSwap)x);
            } else {
                ClassInfo ci = ClassInfo.of((Class)x);
                if (ci.isChildOf(ObjectSwap.class)) {
                    _swaps.add(BeanCreator.of(ObjectSwap.class).type(ci).run());
                } else if (ci.isChildOf(Surrogate.class)) {
                    _swaps.addAll(SurrogateSwap.findObjectSwaps(ci.inner(), this));
                } else {
                    throw ThrowableUtils.runtimeException("Invalid class {0} specified in BeanContext.swaps property.  Must be a subclass of ObjectSwap or Surrogate.", ci.inner());
                }
            }
        });
        this.swapArray = _swaps.toArray(new ObjectSwap[_swaps.size()]);
        this.cmCache = new ConcurrentHashMap<Class, ClassMeta>();
        this.cmCache.put(String.class, new ClassMeta<String>(String.class, this, this.findObjectSwaps(String.class), this.findChildObjectSwaps(String.class)));
        this.cmCache.put(Object.class, new ClassMeta<Object>(Object.class, this, this.findObjectSwaps(Object.class), this.findChildObjectSwaps(Object.class)));
        this.cmString = this.cmCache.get(String.class);
        this.cmObject = this.cmCache.get(Object.class);
        this.cmClass = this.cmCache.get(Class.class);
        this.beanRegistry = new BeanRegistry(this, null, new Class[0]);
        this.defaultSession = this.createSession().unmodifiable().build();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public BeanSession.Builder createSession() {
        return BeanSession.create(this);
    }

    @Override
    public BeanSession getSession() {
        return this.defaultSession;
    }

    public final boolean hasSameCache(BeanContext bc) {
        return bc.cmCache == this.cmCache;
    }

    public <T> BeanMap<T> toBeanMap(T object) {
        return this.defaultSession.toBeanMap(object);
    }

    public <T> BeanMap<T> newBeanMap(Class<T> c) {
        return this.defaultSession.newBeanMap(c);
    }

    public final <T> T convertToType(Object value, Class<T> type) throws InvalidDataConversionException {
        return this.defaultSession.convertToType(value, type);
    }

    public final <T> T convertToMemberType(Object outer, Object value, Class<T> type) throws InvalidDataConversionException {
        return this.defaultSession.convertToMemberType(outer, value, this.getClassMeta(type));
    }

    public final <T> T convertToType(Object value, Type type, Type ... args) throws InvalidDataConversionException {
        return this.defaultSession.convertToMemberType(null, value, this.getClassMeta(type, args));
    }

    protected final boolean isNotABean(Class<?> c) {
        if (c.isArray() || c.isPrimitive() || c.isEnum() || c.isAnnotation()) {
            return true;
        }
        Package p = c.getPackage();
        if (p != null) {
            for (String p2 : this.notBeanPackageNames) {
                if (!p.getName().equals(p2)) continue;
                return true;
            }
            for (String p2 : this.notBeanPackagePrefixes) {
                if (!p.getName().startsWith(p2)) continue;
                return true;
            }
        }
        ClassInfo ci = ClassInfo.of(c);
        for (Class<?> exclude : this.notBeanClassesArray) {
            if (!ci.isChildOf(exclude)) continue;
            return true;
        }
        return false;
    }

    public boolean isBean(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClassMetaForObject(o).isBean();
    }

    public final <T> BeanMeta<T> getBeanMeta(Class<T> c) {
        if (c == null) {
            return null;
        }
        return this.getClassMeta(c).getBeanMeta();
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.getClassMeta(type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> ClassMeta<T> getClassMeta(Class<T> type, boolean waitForInit) {
        if (this.cmCache == null) {
            return null;
        }
        ClassMeta<T> cm = this.cmCache.get(type);
        if (cm == null) {
            BeanContext beanContext = this;
            synchronized (beanContext) {
                cm = this.cmCache.get(type);
                if (cm == null) {
                    cm = new ClassMeta<T>(type, this, this.findObjectSwaps(type), this.findChildObjectSwaps(type));
                }
            }
        }
        if (waitForInit) {
            cm.waitForInit();
        }
        return cm;
    }

    public final <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        ClassMeta cm;
        if (type == null) {
            return null;
        }
        ClassMeta classMeta = cm = type instanceof Class ? this.getClassMeta((Class)type) : this.resolveClassMeta(type, null);
        if (args.length == 0) {
            return cm;
        }
        ClassMeta[] cma = new ClassMeta[args.length + 1];
        cma[0] = cm;
        for (int i = 0; i < Array.getLength(args); ++i) {
            Type arg = (Type)Array.get(args, i);
            cma[i + 1] = arg instanceof Class ? this.getClassMeta((Class)arg) : this.resolveClassMeta(arg, null);
        }
        return this.getTypedClassMeta(cma, 0);
    }

    private ClassMeta<?> getTypedClassMeta(ClassMeta<?>[] c, int pos) {
        ClassMeta cm;
        if ((cm = c[pos++]).isCollection() || cm.isOptional()) {
            ClassMeta<Object> ce = c.length == pos ? this.object() : this.getTypedClassMeta(c, pos);
            return ce.isObject() ? cm : new ClassMeta(cm, null, null, ce);
        }
        if (cm.isMap()) {
            ClassMeta<Object> ck = c.length == pos ? this.object() : c[pos++];
            ClassMeta<Object> cv = c.length == pos ? this.object() : this.getTypedClassMeta(c, pos);
            return ck.isObject() && cv.isObject() ? cm : new ClassMeta(cm, ck, cv, null);
        }
        return cm;
    }

    final ClassMeta resolveClassMeta(Type o, Map<Class<?>, Class<?>[]> typeVarImpls) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClassMeta) {
            ClassMeta cm = (ClassMeta)o;
            if (cm.getBeanContext() == this) {
                return cm;
            }
            if (cm.isMap()) {
                return this.getClassMeta(cm.innerClass, cm.getKeyType(), cm.getValueType());
            }
            if (cm.isCollection() || cm.isOptional()) {
                return this.getClassMeta(cm.innerClass, cm.getElementType());
            }
            return this.getClassMeta(cm.innerClass);
        }
        Class c = this.resolve(o, typeVarImpls);
        if (c == null) {
            return this.object();
        }
        ClassMeta rawType = this.getClassMeta(c);
        if (rawType.isMap() || rawType.isCollection() || rawType.isOptional()) {
            ClassMeta[] params = this.findParameters(o, c);
            if (params == null) {
                return rawType;
            }
            if (rawType.isMap()) {
                if (params.length != 2 || params[0].isObject() && params[1].isObject()) {
                    return rawType;
                }
                return new ClassMeta(rawType, params[0], params[1], null);
            }
            if (rawType.isCollection() || rawType.isOptional()) {
                if (params.length != 1 || params[0].isObject()) {
                    return rawType;
                }
                return new ClassMeta(rawType, null, null, params[0]);
            }
        }
        if (rawType.isArray() && o instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)o;
            ClassMeta elementType = this.resolveClassMeta(gat.getGenericComponentType(), typeVarImpls);
            return new ClassMeta(rawType, null, null, elementType);
        }
        return rawType;
    }

    final Class resolve(Type t, Map<Class<?>, Class<?>[]> typeVarImpls) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof GenericArrayType) {
            Type gatct = ((GenericArrayType)t).getGenericComponentType();
            if (gatct instanceof Class) {
                return Array.newInstance((Class)gatct, 0).getClass();
            }
            if (gatct instanceof ParameterizedType) {
                return Array.newInstance((Class)((ParameterizedType)gatct).getRawType(), 0).getClass();
            }
            if (gatct instanceof GenericArrayType) {
                return Array.newInstance(this.resolve(gatct, typeVarImpls), 0).getClass();
            }
            return null;
        }
        if (t instanceof TypeVariable && typeVarImpls != null) {
            TypeVariable tv = (TypeVariable)t;
            String varName = tv.getName();
            int varIndex = -1;
            Class gc = (Class)tv.getGenericDeclaration();
            TypeVariable<Class<T>>[] tvv = gc.getTypeParameters();
            for (int i = 0; i < tvv.length; ++i) {
                if (!tvv[i].getName().equals(varName)) continue;
                varIndex = i;
            }
            if (varIndex != -1) {
                if (!typeVarImpls.containsKey(gc)) {
                    return null;
                }
                return typeVarImpls.get(gc)[varIndex];
            }
        }
        return null;
    }

    final ClassMeta[] findParameters(Type o, Class c) {
        ParameterizedType pt;
        if (o == null) {
            o = c;
        }
        if (!(o instanceof ParameterizedType)) {
            block0: while (!((o = c.getGenericSuperclass()) instanceof ParameterizedType)) {
                for (Type t : c.getGenericInterfaces()) {
                    o = t;
                    if (o instanceof ParameterizedType) break block0;
                }
                if ((c = c.getSuperclass()) != null) continue;
            }
        }
        if (o instanceof ParameterizedType && !(pt = (ParameterizedType)o).getRawType().equals(Enum.class)) {
            LinkedList<ClassMeta> l = new LinkedList<ClassMeta>();
            for (Type pt2 : pt.getActualTypeArguments()) {
                if (pt2 instanceof WildcardType || pt2 instanceof TypeVariable) {
                    return null;
                }
                l.add(this.resolveClassMeta(pt2, null));
            }
            if (l.isEmpty()) {
                return null;
            }
            return l.toArray(new ClassMeta[l.size()]);
        }
        return null;
    }

    public final <T> ClassMeta<T> getClassMetaForObject(T o) {
        if (o == null) {
            return null;
        }
        return this.getClassMeta(o.getClass());
    }

    protected final <T> ClassMeta<T> resolveClassMeta(Beanp p, Type t, Map<Class<?>, Class<?>[]> typeVarImpls) {
        ClassMeta cm;
        ClassMeta cm2 = cm = this.resolveClassMeta(t, typeVarImpls);
        if (p != null) {
            if (ClassUtils.isNotVoid(p.type())) {
                cm2 = this.resolveClassMeta(p.type(), typeVarImpls);
            }
            if (cm2.isMap()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (p.params().length == 0) {
                    Class[] classArray2 = new Class[2];
                    classArray2[0] = Object.class;
                    classArray = classArray2;
                    classArray2[1] = Object.class;
                } else {
                    classArray = pParams = p.params();
                }
                if (pParams.length != 2) {
                    throw ThrowableUtils.runtimeException("Invalid number of parameters specified for Map (must be 2): {0}", pParams.length);
                }
                ClassMeta<?> keyType = this.resolveType(pParams[0], cm2.getKeyType(), cm.getKeyType());
                ClassMeta<?> valueType = this.resolveType(pParams[1], cm2.getValueType(), cm.getValueType());
                if (keyType.isObject() && valueType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, keyType, valueType, null);
            }
            if (cm2.isCollection() || cm2.isOptional()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (p.params().length == 0) {
                    Class[] classArray3 = new Class[1];
                    classArray = classArray3;
                    classArray3[0] = Object.class;
                } else {
                    classArray = pParams = p.params();
                }
                if (pParams.length != 1) {
                    throw ThrowableUtils.runtimeException("Invalid number of parameters specified for {1} (must be 1): {0}", pParams.length, cm2.isCollection() ? "Collection" : (cm2.isOptional() ? "Optional" : "Array"));
                }
                ClassMeta<?> elementType = this.resolveType(pParams[0], cm2.getElementType(), cm.getElementType());
                if (elementType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, null, null, elementType);
            }
            return cm2;
        }
        return cm;
    }

    private ClassMeta<?> resolveType(Type ... t) {
        for (Type tt : t) {
            if (tt == null) continue;
            ClassMeta cm = this.getClassMeta(tt, new Type[0]);
            if (tt == this.cmObject) continue;
            return cm;
        }
        return this.cmObject;
    }

    private final <T> ObjectSwap[] findObjectSwaps(Class<T> c) {
        if (c != null) {
            ArrayList<ObjectSwap> l = CollectionUtils.list(new ObjectSwap[0]);
            for (ObjectSwap f : this.swapArray) {
                if (!f.getNormalClass().isParentOf(c)) continue;
                l.add(f);
            }
            return l.size() == 0 ? null : l.toArray(new ObjectSwap[l.size()]);
        }
        return null;
    }

    private final ObjectSwap[] findChildObjectSwaps(Class<?> c) {
        if (c == null || this.swapArray.length == 0) {
            return null;
        }
        ArrayList<ObjectSwap> l = null;
        for (ObjectSwap f : this.swapArray) {
            if (!f.getNormalClass().isChildOf(c)) continue;
            if (l == null) {
                l = CollectionUtils.list(new ObjectSwap[0]);
            }
            l.add(f);
        }
        return l == null ? null : l.toArray(new ObjectSwap[l.size()]);
    }

    protected final ClassMeta<Object> object() {
        return this.cmObject;
    }

    protected final ClassMeta<String> string() {
        return this.cmString;
    }

    protected final ClassMeta<Class> _class() {
        return this.cmClass;
    }

    protected final BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public final Visibility getBeanClassVisibility() {
        return this.beanClassVisibility;
    }

    public final Visibility getBeanConstructorVisibility() {
        return this.beanConstructorVisibility;
    }

    public final List<Class<?>> getBeanDictionary() {
        return this.beanDictionary;
    }

    public final Visibility getBeanFieldVisibility() {
        return this.beanFieldVisibility;
    }

    public final boolean isBeanMapPutReturnsOldValue() {
        return this.beanMapPutReturnsOldValue;
    }

    public final Visibility getBeanMethodVisibility() {
        return this.beanMethodVisibility;
    }

    public final boolean isBeansRequireDefaultConstructor() {
        return this.beansRequireDefaultConstructor;
    }

    public final boolean isBeansRequireSerializable() {
        return this.beansRequireSerializable;
    }

    public final boolean isBeansRequireSettersForGetters() {
        return this.beansRequireSettersForGetters;
    }

    public final boolean isBeansRequireSomeProperties() {
        return this.beansRequireSomeProperties;
    }

    public final String getBeanTypePropertyName() {
        return this.typePropertyName;
    }

    public final boolean isFindFluentSetters() {
        return this.findFluentSetters;
    }

    public final boolean isIgnoreInvocationExceptionsOnGetters() {
        return this.ignoreInvocationExceptionsOnGetters;
    }

    public final boolean isIgnoreInvocationExceptionsOnSetters() {
        return this.ignoreInvocationExceptionsOnSetters;
    }

    public final boolean isIgnoreMissingSetters() {
        return this.ignoreMissingSetters;
    }

    protected final boolean isIgnoreTransientFields() {
        return this.ignoreTransientFields;
    }

    public final boolean isIgnoreUnknownBeanProperties() {
        return this.ignoreUnknownBeanProperties;
    }

    public final boolean isIgnoreUnknownEnumValues() {
        return this.ignoreUnknownEnumValues;
    }

    public final boolean isIgnoreUnknownNullBeanProperties() {
        return this.ignoreUnknownNullBeanProperties;
    }

    protected final Class<?>[] getNotBeanClasses() {
        return this.notBeanClassesArray;
    }

    public final String[] getNotBeanPackagesNames() {
        return this.notBeanPackageNames;
    }

    protected final String[] getNotBeanPackagesPrefixes() {
        return this.notBeanPackagePrefixes;
    }

    public final ObjectSwap<?, ?>[] getSwaps() {
        return this.swapArray;
    }

    public final PropertyNamer getPropertyNamer() {
        return this.propertyNamerBean;
    }

    public final boolean isSortProperties() {
        return this.sortProperties;
    }

    public final boolean isUseEnumNames() {
        return this.useEnumNames;
    }

    public final boolean isUseInterfaceProxies() {
        return this.useInterfaceProxies;
    }

    public final boolean isUseJavaBeanIntrospector() {
        return this.useJavaBeanIntrospector;
    }

    public final Locale getDefaultLocale() {
        return this.locale;
    }

    public final MediaType getDefaultMediaType() {
        return this.mediaType;
    }

    public final TimeZone getDefaultTimeZone() {
        return this.timeZone;
    }

    protected WriterSerializer getBeanToStringSerializer() {
        if (this.beanToStringSerializer == null) {
            if (JsonSerializer.DEFAULT == null) {
                return null;
            }
            this.beanToStringSerializer = JsonSerializer.create().beanContext(this).sq().simpleMode().build();
        }
        return this.beanToStringSerializer;
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap().append("id", System.identityHashCode(this)).append("beanClassVisibility", (Object)this.beanClassVisibility).append("beanConstructorVisibility", (Object)this.beanConstructorVisibility).append("beanDictionary", this.beanDictionary).append("beanFieldVisibility", (Object)this.beanFieldVisibility).append("beanMethodVisibility", (Object)this.beanMethodVisibility).append("beansRequireDefaultConstructor", this.beansRequireDefaultConstructor).append("beansRequireSerializable", this.beansRequireSerializable).append("beansRequireSettersForGetters", this.beansRequireSettersForGetters).append("beansRequireSomeProperties", this.beansRequireSomeProperties).append("ignoreTransientFields", this.ignoreTransientFields).append("ignoreInvocationExceptionsOnGetters", this.ignoreInvocationExceptionsOnGetters).append("ignoreInvocationExceptionsOnSetters", this.ignoreInvocationExceptionsOnSetters).append("ignoreUnknownBeanProperties", this.ignoreUnknownBeanProperties).append("ignoreUnknownNullBeanProperties", this.ignoreUnknownNullBeanProperties).append("notBeanClasses", this.notBeanClasses).append("notBeanPackageNames", this.notBeanPackageNames).append("notBeanPackagePrefixes", this.notBeanPackagePrefixes).append("swaps", this.swaps).append("sortProperties", this.sortProperties).append("useEnumNames", this.useEnumNames).append("useInterfaceProxies", this.useInterfaceProxies).append("useJavaBeanIntrospector", this.useJavaBeanIntrospector);
    }

    @FluentSetters
    public static class Builder
    extends Context.Builder {
        private static final Cache<HashKey, BeanContext> CACHE = Cache.of(HashKey.class, BeanContext.class).build();
        Visibility beanClassVisibility;
        Visibility beanConstructorVisibility;
        Visibility beanMethodVisibility;
        Visibility beanFieldVisibility;
        boolean disableBeansRequireSomeProperties;
        boolean beanMapPutReturnsOldValue;
        boolean beansRequireDefaultConstructor;
        boolean beansRequireSerializable;
        boolean beansRequireSettersForGetters;
        boolean disableIgnoreTransientFields;
        boolean disableIgnoreUnknownNullBeanProperties;
        boolean disableIgnoreMissingSetters;
        boolean disableInterfaceProxies;
        boolean findFluentSetters;
        boolean ignoreInvocationExceptionsOnGetters;
        boolean ignoreInvocationExceptionsOnSetters;
        boolean ignoreUnknownBeanProperties;
        boolean ignoreUnknownEnumValues;
        boolean sortProperties;
        boolean useEnumNames;
        boolean useJavaBeanIntrospector;
        String typePropertyName;
        MediaType mediaType;
        Locale locale;
        TimeZone timeZone;
        Class<? extends PropertyNamer> propertyNamer;
        List<Class<?>> beanDictionary;
        List<Object> swaps;
        Set<Class<?>> notBeanClasses;
        Set<String> notBeanPackages;

        protected Builder() {
            this.beanClassVisibility = this.env("BeanContext.beanClassVisibility", Visibility.PUBLIC);
            this.beanConstructorVisibility = this.env("BeanContext.beanConstructorVisibility", Visibility.PUBLIC);
            this.beanMethodVisibility = this.env("BeanContext.beanMethodVisibility", Visibility.PUBLIC);
            this.beanFieldVisibility = this.env("BeanContext.beanFieldVisibility", Visibility.PUBLIC);
            this.beanDictionary = null;
            this.swaps = null;
            this.notBeanClasses = null;
            this.notBeanPackages = null;
            this.disableBeansRequireSomeProperties = this.env("BeanContext.disableBeansRequireSomeProperties", false);
            this.beanMapPutReturnsOldValue = this.env("BeanContext.beanMapPutReturnsOldValue", false);
            this.beansRequireDefaultConstructor = this.env("BeanContext.beansRequireDefaultConstructor", false);
            this.beansRequireSerializable = this.env("BeanContext.beansRequireSerializable", false);
            this.beansRequireSettersForGetters = this.env("BeanContext.beansRequireSettersForGetters", false);
            this.disableIgnoreTransientFields = this.env("BeanContext.disableIgnoreTransientFields", false);
            this.disableIgnoreUnknownNullBeanProperties = this.env("BeanContext.disableIgnoreUnknownNullBeanProperties", false);
            this.disableIgnoreMissingSetters = this.env("BeanContext.disableIgnoreMissingSetters", false);
            this.disableInterfaceProxies = this.env("BeanContext.disableInterfaceProxies", false);
            this.findFluentSetters = this.env("BeanContext.findFluentSetters", false);
            this.ignoreInvocationExceptionsOnGetters = this.env("BeanContext.ignoreInvocationExceptionsOnGetters", false);
            this.ignoreInvocationExceptionsOnSetters = this.env("BeanContext.ignoreInvocationExceptionsOnSetters", false);
            this.ignoreUnknownBeanProperties = this.env("BeanContext.ignoreUnknownBeanProperties", false);
            this.ignoreUnknownEnumValues = this.env("BeanContext.ignoreUnknownEnumValues", false);
            this.sortProperties = this.env("BeanContext.sortProperties", false);
            this.useEnumNames = this.env("BeanContext.useEnumNames", false);
            this.useJavaBeanIntrospector = this.env("BeanContext.useJavaBeanIntrospector", false);
            this.typePropertyName = this.env("BeanContext.typePropertyName", "_type");
            this.mediaType = this.env("BeanContext.mediaType", null);
            this.timeZone = this.env("BeanContext.timeZone", null);
            this.locale = this.env("BeanContext.locale", Locale.getDefault());
            this.propertyNamer = null;
        }

        protected Builder(BeanContext copyFrom) {
            super(copyFrom);
            this.beanClassVisibility = copyFrom.beanClassVisibility;
            this.beanConstructorVisibility = copyFrom.beanConstructorVisibility;
            this.beanMethodVisibility = copyFrom.beanMethodVisibility;
            this.beanFieldVisibility = copyFrom.beanFieldVisibility;
            this.beanDictionary = CollectionUtils.listFrom(copyFrom.beanDictionary, true);
            this.swaps = CollectionUtils.listFrom(copyFrom.swaps, true);
            this.notBeanClasses = Builder.classSet(copyFrom.notBeanClasses, true);
            this.notBeanPackages = CollectionUtils.sortedSetFrom(copyFrom.notBeanPackages, true);
            this.disableBeansRequireSomeProperties = !copyFrom.beansRequireSomeProperties;
            this.beanMapPutReturnsOldValue = copyFrom.beanMapPutReturnsOldValue;
            this.beansRequireDefaultConstructor = copyFrom.beansRequireDefaultConstructor;
            this.beansRequireSerializable = copyFrom.beansRequireSerializable;
            this.beansRequireSettersForGetters = copyFrom.beansRequireSettersForGetters;
            this.disableIgnoreTransientFields = !copyFrom.ignoreTransientFields;
            this.disableIgnoreUnknownNullBeanProperties = !copyFrom.ignoreUnknownNullBeanProperties;
            this.disableIgnoreMissingSetters = !copyFrom.ignoreMissingSetters;
            this.disableInterfaceProxies = !copyFrom.useInterfaceProxies;
            this.findFluentSetters = copyFrom.findFluentSetters;
            this.ignoreInvocationExceptionsOnGetters = copyFrom.ignoreInvocationExceptionsOnGetters;
            this.ignoreInvocationExceptionsOnSetters = copyFrom.ignoreInvocationExceptionsOnSetters;
            this.ignoreUnknownBeanProperties = copyFrom.ignoreUnknownBeanProperties;
            this.ignoreUnknownEnumValues = copyFrom.ignoreUnknownEnumValues;
            this.sortProperties = copyFrom.sortProperties;
            this.useEnumNames = copyFrom.useEnumNames;
            this.useJavaBeanIntrospector = copyFrom.useJavaBeanIntrospector;
            this.typePropertyName = copyFrom.typePropertyName;
            this.mediaType = copyFrom.mediaType;
            this.timeZone = copyFrom.timeZone;
            this.locale = copyFrom.locale;
            this.propertyNamer = copyFrom.propertyNamer;
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.beanClassVisibility = copyFrom.beanClassVisibility;
            this.beanConstructorVisibility = copyFrom.beanConstructorVisibility;
            this.beanMethodVisibility = copyFrom.beanMethodVisibility;
            this.beanFieldVisibility = copyFrom.beanFieldVisibility;
            this.beanDictionary = CollectionUtils.copyOf(copyFrom.beanDictionary);
            this.swaps = CollectionUtils.copyOf(copyFrom.swaps);
            this.notBeanClasses = Builder.classSet(copyFrom.notBeanClasses);
            this.notBeanPackages = CollectionUtils.sortedSetFrom(copyFrom.notBeanPackages);
            this.disableBeansRequireSomeProperties = copyFrom.disableBeansRequireSomeProperties;
            this.beanMapPutReturnsOldValue = copyFrom.beanMapPutReturnsOldValue;
            this.beansRequireDefaultConstructor = copyFrom.beansRequireDefaultConstructor;
            this.beansRequireSerializable = copyFrom.beansRequireSerializable;
            this.beansRequireSettersForGetters = copyFrom.beansRequireSettersForGetters;
            this.disableIgnoreTransientFields = copyFrom.disableIgnoreTransientFields;
            this.disableIgnoreUnknownNullBeanProperties = copyFrom.disableIgnoreUnknownNullBeanProperties;
            this.disableIgnoreMissingSetters = copyFrom.disableIgnoreMissingSetters;
            this.disableInterfaceProxies = copyFrom.disableInterfaceProxies;
            this.findFluentSetters = copyFrom.findFluentSetters;
            this.ignoreInvocationExceptionsOnGetters = copyFrom.ignoreInvocationExceptionsOnGetters;
            this.ignoreInvocationExceptionsOnSetters = copyFrom.ignoreInvocationExceptionsOnSetters;
            this.ignoreUnknownBeanProperties = copyFrom.ignoreUnknownBeanProperties;
            this.ignoreUnknownEnumValues = copyFrom.ignoreUnknownEnumValues;
            this.sortProperties = copyFrom.sortProperties;
            this.useEnumNames = copyFrom.useEnumNames;
            this.useJavaBeanIntrospector = copyFrom.useJavaBeanIntrospector;
            this.typePropertyName = copyFrom.typePropertyName;
            this.mediaType = copyFrom.mediaType;
            this.timeZone = copyFrom.timeZone;
            this.locale = copyFrom.locale;
            this.propertyNamer = copyFrom.propertyNamer;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public BeanContext build() {
            return this.cache(CACHE).build(BeanContext.class);
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of(new Object[]{super.hashKey(), this.beanClassVisibility, this.beanConstructorVisibility, this.beanMethodVisibility, this.beanFieldVisibility, this.beanDictionary, this.swaps, this.notBeanClasses, this.notBeanPackages, this.integer(this.disableBeansRequireSomeProperties, this.beanMapPutReturnsOldValue, this.beansRequireDefaultConstructor, this.beansRequireSerializable, this.beansRequireSettersForGetters, this.disableIgnoreTransientFields, this.disableIgnoreUnknownNullBeanProperties, this.disableIgnoreMissingSetters, this.disableInterfaceProxies, this.findFluentSetters, this.ignoreInvocationExceptionsOnGetters, this.ignoreInvocationExceptionsOnSetters, this.ignoreUnknownBeanProperties, this.ignoreUnknownEnumValues, this.sortProperties, this.useEnumNames, this.useJavaBeanIntrospector), this.typePropertyName, this.mediaType, this.timeZone, this.locale, this.propertyNamer});
        }

        private int integer(boolean ... values) {
            int n = 0;
            for (boolean b : values) {
                n = n << 1 | (b ? 1 : 0);
            }
            return n;
        }

        @FluentSetter
        public Builder beanClassVisibility(Visibility value) {
            this.beanClassVisibility = value;
            return this;
        }

        @FluentSetter
        public Builder beanConstructorVisibility(Visibility value) {
            this.beanConstructorVisibility = value;
            return this;
        }

        @FluentSetter
        public Builder beanFieldVisibility(Visibility value) {
            this.beanFieldVisibility = value;
            return this;
        }

        @FluentSetter
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            return this.annotations(BeanAnnotation.create(on).interceptor(value).build());
        }

        @FluentSetter
        public Builder beanMapPutReturnsOldValue() {
            return this.beanMapPutReturnsOldValue(true);
        }

        @FluentSetter
        public Builder beanMapPutReturnsOldValue(boolean value) {
            this.beanMapPutReturnsOldValue = value;
            return this;
        }

        @FluentSetter
        public Builder beanMethodVisibility(Visibility value) {
            this.beanMethodVisibility = value;
            return this;
        }

        @FluentSetter
        public Builder beansRequireDefaultConstructor() {
            return this.beansRequireDefaultConstructor(true);
        }

        @FluentSetter
        public Builder beansRequireDefaultConstructor(boolean value) {
            this.beansRequireDefaultConstructor = value;
            return this;
        }

        @FluentSetter
        public Builder beansRequireSerializable() {
            return this.beansRequireSerializable(true);
        }

        @FluentSetter
        public Builder beansRequireSerializable(boolean value) {
            this.beansRequireSerializable = value;
            return this;
        }

        @FluentSetter
        public Builder beansRequireSettersForGetters() {
            return this.beansRequireSettersForGetters(true);
        }

        @FluentSetter
        public Builder beansRequireSettersForGetters(boolean value) {
            this.beansRequireSettersForGetters = value;
            return this;
        }

        @FluentSetter
        public Builder disableBeansRequireSomeProperties() {
            return this.disableBeansRequireSomeProperties(true);
        }

        @FluentSetter
        public Builder disableBeansRequireSomeProperties(boolean value) {
            this.disableBeansRequireSomeProperties = value;
            return this;
        }

        @FluentSetter
        public Builder beanProperties(Class<?> beanClass, String properties) {
            return this.annotations(BeanAnnotation.create(beanClass).p(properties).build());
        }

        @FluentSetter
        public Builder beanProperties(Map<String, Object> values) {
            values.forEach((k, v) -> this.annotations(BeanAnnotation.create(k).p(StringUtils.stringify(v)).build()));
            return this;
        }

        @FluentSetter
        public Builder beanProperties(String beanClassName, String properties) {
            return this.annotations(BeanAnnotation.create(beanClassName).p(properties).build());
        }

        @FluentSetter
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            return this.annotations(BeanAnnotation.create(beanClass).xp(properties).build());
        }

        @FluentSetter
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            values.forEach((k, v) -> this.annotations(BeanAnnotation.create(k).xp(StringUtils.stringify(v)).build()));
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            return this.annotations(BeanAnnotation.create(beanClassName).xp(properties).build());
        }

        @FluentSetter
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            return this.annotations(BeanAnnotation.create(beanClass).ro(properties).build());
        }

        @FluentSetter
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            values.forEach((k, v) -> this.annotations(BeanAnnotation.create(k).ro(StringUtils.stringify(v)).build()));
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            return this.annotations(BeanAnnotation.create(beanClassName).ro(properties).build());
        }

        @FluentSetter
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            return this.annotations(BeanAnnotation.create(beanClass).wo(properties).build());
        }

        @FluentSetter
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            values.forEach((k, v) -> this.annotations(BeanAnnotation.create(k).wo(StringUtils.stringify(v)).build()));
            return this;
        }

        @FluentSetter
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            return this.annotations(BeanAnnotation.create(beanClassName).wo(properties).build());
        }

        @FluentSetter
        public Builder beanDictionary(Class<?> ... values) {
            return this.beanDictionary(CollectionUtils.alist(values));
        }

        @FluentSetter
        public Builder beanDictionary(Collection<Class<?>> values) {
            this.beanDictionary().addAll(0, values);
            return this;
        }

        public List<Class<?>> beanDictionary() {
            if (this.beanDictionary == null) {
                this.beanDictionary = CollectionUtils.list(new Class[0]);
            }
            return this.beanDictionary;
        }

        @FluentSetter
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            return this.annotations(BeanAnnotation.create(on).dictionary(values).build());
        }

        @FluentSetter
        public <T> Builder example(Class<T> pojoClass, T o) {
            return this.annotations(MarshalledAnnotation.create(pojoClass).example(StringUtils.json(o)).build());
        }

        @FluentSetter
        public <T> Builder example(Class<T> pojoClass, String json) {
            return this.annotations(MarshalledAnnotation.create(pojoClass).example(json).build());
        }

        @FluentSetter
        public Builder findFluentSetters() {
            return this.findFluentSetters(true);
        }

        @FluentSetter
        public Builder findFluentSetters(boolean value) {
            this.findFluentSetters = value;
            return this;
        }

        @FluentSetter
        public Builder findFluentSetters(Class<?> on) {
            return this.annotations(BeanAnnotation.create(on).findFluentSetters(true).build());
        }

        @FluentSetter
        public Builder ignoreInvocationExceptionsOnGetters() {
            return this.ignoreInvocationExceptionsOnGetters(true);
        }

        @FluentSetter
        public Builder ignoreInvocationExceptionsOnGetters(boolean value) {
            this.ignoreInvocationExceptionsOnGetters = value;
            return this;
        }

        @FluentSetter
        public Builder ignoreInvocationExceptionsOnSetters() {
            return this.ignoreInvocationExceptionsOnSetters(true);
        }

        @FluentSetter
        public Builder ignoreInvocationExceptionsOnSetters(boolean value) {
            this.ignoreInvocationExceptionsOnSetters = value;
            return this;
        }

        @FluentSetter
        public Builder disableIgnoreMissingSetters() {
            return this.disableIgnoreMissingSetters(true);
        }

        @FluentSetter
        public Builder disableIgnoreMissingSetters(boolean value) {
            this.disableIgnoreMissingSetters = value;
            return this;
        }

        @FluentSetter
        public Builder disableIgnoreTransientFields() {
            return this.disableIgnoreTransientFields(true);
        }

        @FluentSetter
        public Builder disableIgnoreTransientFields(boolean value) {
            this.disableIgnoreTransientFields = value;
            return this;
        }

        @FluentSetter
        public Builder ignoreUnknownBeanProperties() {
            return this.ignoreUnknownBeanProperties(true);
        }

        @FluentSetter
        public Builder ignoreUnknownBeanProperties(boolean value) {
            this.ignoreUnknownBeanProperties = value;
            return this;
        }

        @FluentSetter
        public Builder ignoreUnknownEnumValues() {
            return this.ignoreUnknownEnumValues(true);
        }

        @FluentSetter
        public Builder ignoreUnknownEnumValues(boolean value) {
            this.ignoreUnknownEnumValues = value;
            return this;
        }

        @FluentSetter
        public Builder disableIgnoreUnknownNullBeanProperties() {
            return this.disableIgnoreUnknownNullBeanProperties(true);
        }

        @FluentSetter
        public Builder disableIgnoreUnknownNullBeanProperties(boolean value) {
            this.disableIgnoreUnknownNullBeanProperties = value;
            return this;
        }

        @FluentSetter
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            return this.annotations(MarshalledAnnotation.create(interfaceClass).implClass(implClass).build());
        }

        @FluentSetter
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            values.forEach((k, v) -> this.annotations(MarshalledAnnotation.create(k).implClass((Class<?>)v).build()));
            return this;
        }

        @FluentSetter
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            return this.annotations(BeanAnnotation.create(on).interfaceClass(value).build());
        }

        @FluentSetter
        public Builder interfaces(Class<?> ... value) {
            for (Class<?> v : value) {
                this.annotations(BeanAnnotation.create(v).interfaceClass(v).build());
            }
            return this;
        }

        @FluentSetter
        public Builder locale(Locale value) {
            this.locale = value;
            return this;
        }

        @FluentSetter
        public Builder mediaType(MediaType value) {
            this.mediaType = value;
            return this;
        }

        @FluentSetter
        public Builder notBeanClasses(Class<?> ... values) {
            return this.notBeanClasses(CollectionUtils.alist(values));
        }

        @FluentSetter
        public Builder notBeanClasses(Collection<Class<?>> values) {
            this.notBeanClasses().addAll(values);
            return this;
        }

        public Set<Class<?>> notBeanClasses() {
            if (this.notBeanClasses == null) {
                this.notBeanClasses = Builder.classSet();
            }
            return this.notBeanClasses;
        }

        @FluentSetter
        public Builder notBeanPackages(String ... values) {
            return this.notBeanPackages(CollectionUtils.alist(values));
        }

        @FluentSetter
        public Builder notBeanPackages(Collection<String> values) {
            this.notBeanPackages().addAll(values);
            return this;
        }

        public Set<String> notBeanPackages() {
            if (this.notBeanPackages == null) {
                this.notBeanPackages = new TreeSet<String>();
            }
            return this.notBeanPackages;
        }

        @FluentSetter
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            this.propertyNamer = value;
            return this;
        }

        @FluentSetter
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            return this.annotations(BeanAnnotation.create(on).propertyNamer(value).build());
        }

        @FluentSetter
        public Builder sortProperties() {
            this.sortProperties = true;
            return this.sortProperties(true);
        }

        @FluentSetter
        public Builder sortProperties(boolean value) {
            this.sortProperties = value;
            return this;
        }

        @FluentSetter
        public Builder sortProperties(Class<?> ... on) {
            for (Class<?> c : on) {
                this.annotations(BeanAnnotation.create(c).sort(true).build());
            }
            return this;
        }

        @FluentSetter
        public Builder stopClass(Class<?> on, Class<?> value) {
            return this.annotations(BeanAnnotation.create(on).stopClass(value).build());
        }

        @FluentSetter
        public Builder swaps(Class<?> ... values) {
            return this.swaps(CollectionUtils.alist(values));
        }

        @FluentSetter
        public Builder swaps(Collection<Class<?>> values) {
            this.swaps().addAll(0, values);
            return this;
        }

        @FluentSetter
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            return this.swap(normalClass, swappedClass, swapFunction, null);
        }

        @FluentSetter
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            this.swaps().add(0, new FunctionalSwap<T, S>(normalClass, swappedClass, swapFunction, unswapFunction));
            return this;
        }

        public List<Object> swaps() {
            if (this.swaps == null) {
                this.swaps = CollectionUtils.list(new Object[0]);
            }
            return this.swaps;
        }

        @FluentSetter
        public Builder timeZone(TimeZone value) {
            this.timeZone = value;
            return this;
        }

        @FluentSetter
        public Builder typeName(Class<?> on, String value) {
            return this.annotations(BeanAnnotation.create(on).typeName(value).build());
        }

        @FluentSetter
        public Builder typePropertyName(String value) {
            this.typePropertyName = value;
            return this;
        }

        @FluentSetter
        public Builder typePropertyName(Class<?> on, String value) {
            return this.annotations(BeanAnnotation.create(on).typePropertyName(value).build());
        }

        @FluentSetter
        public Builder useEnumNames() {
            return this.useEnumNames(true);
        }

        @FluentSetter
        public Builder useEnumNames(boolean value) {
            this.useEnumNames = value;
            return this;
        }

        @FluentSetter
        public Builder disableInterfaceProxies() {
            return this.disableInterfaceProxies(true);
        }

        @FluentSetter
        public Builder disableInterfaceProxies(boolean value) {
            this.disableInterfaceProxies = value;
            return this;
        }

        @FluentSetter
        public Builder useJavaBeanIntrospector() {
            return this.useJavaBeanIntrospector(true);
        }

        @FluentSetter
        public Builder useJavaBeanIntrospector(boolean value) {
            this.useJavaBeanIntrospector = value;
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations(fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        private static Set<Class<?>> classSet() {
            return new TreeSet(Comparator.comparing(Class::getName));
        }

        private static Set<Class<?>> classSet(Collection<Class<?>> copy) {
            return Builder.classSet(copy, false);
        }

        private static Set<Class<?>> classSet(Collection<Class<?>> copy, boolean nullIfEmpty) {
            if (copy == null || nullIfEmpty && copy.isEmpty()) {
                return null;
            }
            Set<Class<?>> x = Builder.classSet();
            x.addAll(copy);
            return x;
        }
    }
}

