/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.http.NameValuePair;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.objecttools.PageArgs;
import org.apache.juneau.objecttools.SearchArgs;
import org.apache.juneau.objecttools.SortArgs;
import org.apache.juneau.objecttools.ViewArgs;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestQueryParam;
import org.apache.juneau.svl.VarResolverSession;

public class RequestQueryParams {
    private final RestRequest req;
    private final boolean caseSensitive;
    private final VarResolverSession vs;
    private HttpPartParserSession parser;
    private List<RequestQueryParam> list = new LinkedList<RequestQueryParam>();
    private Map<String, List<RequestQueryParam>> map = new TreeMap<String, List<RequestQueryParam>>();

    public RequestQueryParams(RestRequest req, Map<String, String[]> query, boolean caseSensitive) {
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        for (Map.Entry<String, String[]> e : query.entrySet()) {
            String name = e.getKey();
            String key = this.key(name);
            ArrayList l = CollectionUtils.list((Object[])new RequestQueryParam[0]);
            String[] values = e.getValue();
            if (values == null) {
                values = new String[]{};
            }
            if (values.length == 1 && values[0] == null) {
                values[0] = "";
            }
            for (String value : values) {
                RequestQueryParam p = new RequestQueryParam(req, name, value);
                this.list.add(p);
                l.add(p);
            }
            this.map.put(key, l);
        }
    }

    private RequestQueryParams(RequestQueryParams copyFrom) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.list.addAll(copyFrom.list);
        this.map.putAll(copyFrom.map);
        this.vs = copyFrom.vs;
    }

    public RequestQueryParams parser(HttpPartParserSession value) {
        this.parser = value;
        for (RequestQueryParam p : this.list) {
            p.parser(this.parser);
        }
        return this;
    }

    public RequestQueryParams addDefault(List<? extends NameValuePair> pairs) {
        for (NameValuePair nameValuePair : pairs) {
            boolean hasAllBlanks;
            String name = nameValuePair.getName();
            String key = this.key(name);
            List<RequestQueryParam> l = this.map.get(key);
            boolean bl = hasAllBlanks = l != null && l.stream().allMatch(x -> StringUtils.isEmpty((String)x.getValue()));
            if (l != null && !hasAllBlanks) continue;
            if (hasAllBlanks) {
                this.list.removeAll(l);
            }
            RequestQueryParam x2 = new RequestQueryParam(this.req, name, this.vs.resolve(nameValuePair.getValue()));
            this.list.add(x2);
            this.map.put(key, CollectionUtils.list((Object[])new RequestQueryParam[]{x2}));
        }
        return this;
    }

    public RequestQueryParams addDefault(NameValuePair ... pairs) {
        return this.addDefault(CollectionUtils.alist((Object[])pairs));
    }

    public RequestQueryParams addDefault(String name, String value) {
        return this.addDefault(new NameValuePair[]{BasicStringPart.of((String)name, (String)value)});
    }

    public List<RequestQueryParam> getAll(String name) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        List<RequestQueryParam> l = this.map.get(this.key(name));
        return l == null ? CollectionUtils.emptyList() : CollectionUtils.unmodifiable(l);
    }

    public List<RequestQueryParam> getAll() {
        return CollectionUtils.unmodifiable(this.list);
    }

    public boolean contains(String ... names) {
        Assertions.assertArgNotNull((String)"names", (Object)names);
        for (String n : names) {
            if (this.map.containsKey(this.key(n))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(String ... names) {
        Assertions.assertArgNotNull((String)"names", (Object)names);
        for (String n : names) {
            if (!this.map.containsKey(this.key(n))) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public RequestQueryParams add(String name, Object value) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        String key = this.key(name);
        RequestQueryParam h = new RequestQueryParam(this.req, name, StringUtils.stringify((Object)value)).parser(this.parser);
        if (this.map.containsKey(key)) {
            this.map.get(key).add(h);
        } else {
            this.map.put(key, CollectionUtils.list((Object[])new RequestQueryParam[]{h}));
        }
        this.list.add(h);
        return this;
    }

    public RequestQueryParams add(NameValuePair ... parameters) {
        Assertions.assertArgNotNull((String)"parameters", (Object)parameters);
        for (NameValuePair p : parameters) {
            if (p == null) continue;
            this.add(p.getName(), p.getValue());
        }
        return this;
    }

    public RequestQueryParams set(String name, Object value) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        String key = this.key(name);
        RequestQueryParam p = new RequestQueryParam(this.req, name, StringUtils.stringify((Object)value)).parser(this.parser);
        if (this.map.containsKey(key)) {
            this.list.removeIf(x -> this.caseSensitive ? x.getName().equals(name) : x.getName().equalsIgnoreCase(name));
        }
        this.list.add(p);
        this.map.put(key, CollectionUtils.list((Object[])new RequestQueryParam[]{p}));
        return this;
    }

    public RequestQueryParams set(NameValuePair ... parameters) {
        Assertions.assertArgNotNull((String)"headers", (Object)parameters);
        for (NameValuePair p : parameters) {
            this.remove(p);
        }
        for (NameValuePair p : parameters) {
            this.add(p);
        }
        return this;
    }

    public RequestQueryParams remove(String ... name) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        for (String n : name) {
            String key = this.key(n);
            if (this.map.containsKey(key)) {
                this.list.removeAll((Collection)this.map.get(key));
            }
            this.map.remove(key);
        }
        return this;
    }

    public RequestQueryParams remove(NameValuePair ... parameters) {
        for (NameValuePair p : parameters) {
            this.remove(p.getName());
        }
        return this;
    }

    public RequestQueryParam getFirst(String name) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        List<RequestQueryParam> l = this.map.get(this.key(name));
        return l == null || l.isEmpty() ? new RequestQueryParam(this.req, name, null).parser(this.parser) : l.get(0);
    }

    public RequestQueryParam getLast(String name) {
        Assertions.assertArgNotNull((String)"name", (Object)name);
        List<RequestQueryParam> l = this.map.get(this.key(name));
        return l == null || l.isEmpty() ? new RequestQueryParam(this.req, name, null).parser(this.parser) : l.get(l.size() - 1);
    }

    public RequestQueryParam get(String name) {
        return this.getLast(name);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta cm = this.req.getBeanSession().getClassMeta(type);
        String name = (String)HttpParts.getName((HttpPartType)HttpPartType.QUERY, (ClassMeta)cm).orElseThrow(() -> ThrowableUtils.runtimeException((String)"@Query(name) not found on class {0}", (Object[])new Object[]{ClassUtils.className((Object)type)}));
        return this.get(name).as(type);
    }

    public String asQueryString() {
        StringBuilder sb = new StringBuilder();
        for (RequestQueryParam e : this.list) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(StringUtils.urlEncode((String)e.getName())).append('=').append(StringUtils.urlEncode((String)e.getValue()));
        }
        return sb.toString();
    }

    public RequestQueryParams copy() {
        return new RequestQueryParams(this);
    }

    public Optional<SearchArgs> getSearchArgs() {
        return Optional.ofNullable(SearchArgs.create((String)this.get("s").asString().orElse(null)));
    }

    public Optional<ViewArgs> getViewArgs() {
        return Optional.ofNullable(ViewArgs.create((String)this.get("v").asString().orElse(null)));
    }

    public Optional<SortArgs> getSortArgs() {
        return Optional.ofNullable(SortArgs.create((String)this.get("o").asString().orElse(null)));
    }

    public Optional<PageArgs> getPageArgs() {
        return Optional.ofNullable(PageArgs.create((Integer)this.get("p").asInteger().orElse(null), (Integer)this.get("l").asInteger().orElse(null)));
    }

    public String toString(boolean sorted) {
        JsonMap m = JsonMap.create();
        if (sorted) {
            for (List<RequestQueryParam> p1 : this.map.values()) {
                for (RequestQueryParam p2 : p1) {
                    m.append(p2.getName(), (Object)p2.getValue());
                }
            }
        } else {
            for (RequestQueryParam p : this.list) {
                m.append(p.getName(), (Object)p.getValue());
            }
        }
        return m.toString();
    }

    private String key(String name) {
        return this.caseSensitive ? name : name.toLowerCase();
    }

    public String toString() {
        return this.toString(false);
    }
}

