/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.objecttools.ObjectIntrospector;
import org.apache.juneau.objecttools.ObjectRestException;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ReaderParser;

public final class ObjectRest {
    private static final int GET = 1;
    private static final int PUT = 2;
    private static final int POST = 3;
    private static final int DELETE = 4;
    private ReaderParser parser = JsonParser.DEFAULT;
    final BeanSession session;
    private boolean rootLocked = false;
    private JsonNode root;

    public static ObjectRest create(Object o) {
        return new ObjectRest(o);
    }

    public static ObjectRest create(Object o, ReaderParser parser) {
        return new ObjectRest(o, parser);
    }

    public ObjectRest(Object o) {
        this(o, null);
    }

    public ObjectRest(Object o, ReaderParser parser) {
        BeanSession beanSession = this.session = parser == null ? BeanContext.DEFAULT_SESSION : parser.getBeanContext().getSession();
        if (parser == null) {
            parser = JsonParser.DEFAULT;
        }
        this.parser = parser;
        this.root = new JsonNode(null, null, o, this.session.object());
    }

    public ObjectRest setRootLocked() {
        this.rootLocked = true;
        return this;
    }

    public Object getRootObject() {
        return this.root.o;
    }

    public Object get(String url) {
        return this.getWithDefault(url, null);
    }

    public Object getWithDefault(String url, Object defVal) {
        Object o = this.service(1, url, null);
        return o == null ? defVal : o;
    }

    public <T> T get(String url, Class<T> type) {
        return this.getWithDefault(url, null, type);
    }

    public <T> T get(String url, Type type, Type ... args) {
        return this.getWithDefault(url, null, type, args);
    }

    public <T> T getWithDefault(String url, T def, Class<T> type) {
        Object o = this.service(1, url, null);
        if (o == null) {
            return def;
        }
        return this.session.convertToType(o, type);
    }

    public <T> T getWithDefault(String url, T def, Type type, Type ... args) {
        Object o = this.service(1, url, null);
        if (o == null) {
            return def;
        }
        return this.session.convertToType(o, type, args);
    }

    public String getString(String url) {
        return this.get(url, String.class);
    }

    public String getString(String url, String defVal) {
        return this.getWithDefault(url, defVal, String.class);
    }

    public Integer getInt(String url) {
        return this.get(url, Integer.class);
    }

    public Integer getInt(String url, Integer defVal) {
        return this.getWithDefault(url, defVal, Integer.class);
    }

    public Long getLong(String url) {
        return this.get(url, Long.class);
    }

    public Long getLong(String url, Long defVal) {
        return this.getWithDefault(url, defVal, Long.class);
    }

    public Boolean getBoolean(String url) {
        return this.get(url, Boolean.class);
    }

    public Boolean getBoolean(String url, Boolean defVal) {
        return this.getWithDefault(url, defVal, Boolean.class);
    }

    public Map<?, ?> getMap(String url) {
        return this.get(url, Map.class);
    }

    public Map<?, ?> getMap(String url, Map<?, ?> defVal) {
        return this.getWithDefault(url, defVal, Map.class);
    }

    public List<?> getList(String url) {
        return this.get(url, List.class);
    }

    public List<?> getList(String url, List<?> defVal) {
        return this.getWithDefault(url, defVal, List.class);
    }

    public JsonMap getJsonMap(String url) {
        return this.get(url, JsonMap.class);
    }

    public JsonMap getJsonMap(String url, JsonMap defVal) {
        return this.getWithDefault(url, defVal, JsonMap.class);
    }

    public JsonList getJsonList(String url) {
        return this.get(url, JsonList.class);
    }

    public JsonList getJsonList(String url, JsonList defVal) {
        return this.getWithDefault(url, defVal, JsonList.class);
    }

    public Object invokeMethod(String url, String method, String args) throws ExecutableException, ParseException, IOException {
        try {
            return new ObjectIntrospector(this.get(url), this.parser).invokeMethod(method, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public Collection<String> getPublicMethods(String url) {
        Object o = this.get(url);
        if (o == null) {
            return null;
        }
        return this.session.getClassMeta(o.getClass()).getPublicMethods().keySet();
    }

    public ClassMeta getClassMeta(String url) {
        JsonNode n = this.getNode(ObjectRest.normalizeUrl(url), this.root);
        if (n == null) {
            return null;
        }
        return n.cm;
    }

    public Object put(String url, Object val) {
        return this.service(2, url, val);
    }

    public String post(String url, Object val) {
        return (String)this.service(3, url, val);
    }

    public Object delete(String url) {
        return this.service(4, url, null);
    }

    public String toString() {
        return String.valueOf(this.root.o);
    }

    private static String normalizeUrl(String url) {
        if (url == null) {
            url = "";
        }
        if (url.length() > 0 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    private Object service(int method, String url, Object val) throws ObjectRestException {
        String childKey;
        url = ObjectRest.normalizeUrl(url);
        if (method == 1) {
            JsonNode p = this.getNode(url, this.root);
            return p == null ? null : p.o;
        }
        int i = url.lastIndexOf(47);
        String parentUrl = i == -1 ? null : url.substring(0, i);
        String string = childKey = i == -1 ? url : url.substring(i + 1);
        if (method == 2) {
            JsonNode n;
            if (url.length() == 0) {
                if (this.rootLocked) {
                    throw new ObjectRestException(403, "Cannot overwrite root object", new Object[0]);
                }
                Object o = this.root.o;
                this.root = new JsonNode(null, null, val, this.session.object());
                return o;
            }
            JsonNode jsonNode = n = parentUrl == null ? this.root : this.getNode(parentUrl, this.root);
            if (n == null) {
                throw new ObjectRestException(404, "Node at URL ''{0}'' not found.", parentUrl);
            }
            ClassMeta cm = n.cm;
            Object[] o = n.o;
            if (cm.isMap()) {
                return ((Map)o).put(childKey, this.convert(val, cm.getValueType()));
            }
            if (cm.isCollection() && o instanceof List) {
                return ((List)o).set(ObjectRest.parseInt(childKey), this.convert(val, cm.getElementType()));
            }
            if (cm.isArray()) {
                o = this.setArrayEntry(n.o, ObjectRest.parseInt(childKey), val, cm.getElementType());
                ClassMeta pct = n.parent.cm;
                Object po = n.parent.o;
                if (pct.isMap()) {
                    ((Map)po).put(n.keyName, o);
                    return url;
                }
                if (pct.isBean()) {
                    BeanMap<Object> m = this.session.toBeanMap(po);
                    m.put(n.keyName, (Object)o);
                    return url;
                }
                throw new ObjectRestException(400, "Cannot perform PUT on ''{0}'' with parent node type ''{1}''", url, pct);
            }
            if (cm.isBean()) {
                return this.session.toBeanMap(o).put(childKey, val);
            }
            throw new ObjectRestException(400, "Cannot perform PUT on ''{0}'' whose parent is of type ''{1}''", url, cm);
        }
        if (method == 3) {
            if (url.length() == 0) {
                ClassMeta cm = this.root.cm;
                Object o = this.root.o;
                if (cm.isCollection()) {
                    Collection c = (Collection)o;
                    c.add(this.convert(val, cm.getElementType()));
                    return c instanceof List ? url + "/" + (c.size() - 1) : null;
                }
                if (cm.isArray()) {
                    Object[] o2 = this.addArrayEntry(o, val, cm.getElementType());
                    this.root = new JsonNode(null, null, o2, null);
                    return url + "/" + (o2.length - 1);
                }
                throw new ObjectRestException(400, "Cannot perform POST on ''{0}'' of type ''{1}''", url, cm);
            }
            JsonNode n = this.getNode(url, this.root);
            if (n == null) {
                throw new ObjectRestException(404, "Node at URL ''{0}'' not found.", url);
            }
            ClassMeta cm = n.cm;
            Object o = n.o;
            if (cm.isArray()) {
                Object[] o2 = this.addArrayEntry(o, val, cm.getElementType());
                ClassMeta pct = n.parent.cm;
                Object po = n.parent.o;
                if (pct.isMap()) {
                    ((Map)po).put(childKey, o2);
                    return url + "/" + (o2.length - 1);
                }
                if (pct.isBean()) {
                    BeanMap<Object> m = this.session.toBeanMap(po);
                    m.put(childKey, (Object)o2);
                    return url + "/" + (o2.length - 1);
                }
                throw new ObjectRestException(400, "Cannot perform POST on ''{0}'' with parent node type ''{1}''", url, pct);
            }
            if (cm.isCollection()) {
                Collection c = (Collection)o;
                c.add(this.convert(val, cm.getElementType()));
                return c instanceof List ? url + "/" + (c.size() - 1) : null;
            }
            throw new ObjectRestException(400, "Cannot perform POST on ''{0}'' of type ''{1}''", url, cm);
        }
        if (method == 4) {
            if (url.length() == 0) {
                if (this.rootLocked) {
                    throw new ObjectRestException(403, "Cannot overwrite root object", new Object[0]);
                }
                Object o = this.root.o;
                this.root = new JsonNode(null, null, null, this.session.object());
                return o;
            }
            JsonNode n = parentUrl == null ? this.root : this.getNode(parentUrl, this.root);
            ClassMeta cm = n.cm;
            Object o = n.o;
            if (cm.isMap()) {
                return ((Map)o).remove(childKey);
            }
            if (cm.isCollection() && o instanceof List) {
                return ((List)o).remove(ObjectRest.parseInt(childKey));
            }
            if (cm.isArray()) {
                int index = ObjectRest.parseInt(childKey);
                Object old = ((Object[])o)[index];
                Object[] o2 = ObjectRest.removeArrayEntry(o, index);
                ClassMeta pct = n.parent.cm;
                Object po = n.parent.o;
                if (pct.isMap()) {
                    ((Map)po).put(n.keyName, o2);
                    return old;
                }
                if (pct.isBean()) {
                    BeanMap<Object> m = this.session.toBeanMap(po);
                    m.put(n.keyName, (Object)o2);
                    return old;
                }
                throw new ObjectRestException(400, "Cannot perform POST on ''{0}'' with parent node type ''{1}''", url, pct);
            }
            if (cm.isBean()) {
                return this.session.toBeanMap(o).put(childKey, (Object)null);
            }
            throw new ObjectRestException(400, "Cannot perform PUT on ''{0}'' whose parent is of type ''{1}''", url, cm);
        }
        return null;
    }

    private Object[] setArrayEntry(Object o, int index, Object val, ClassMeta componentType) {
        Object[] a = (Object[])o;
        if (a.length <= index) {
            Object[] a2 = (Object[])Array.newInstance(a.getClass().getComponentType(), index + 1);
            System.arraycopy(a, 0, a2, 0, a.length);
            a = a2;
        }
        a[index] = this.convert(val, componentType);
        return a;
    }

    private Object[] addArrayEntry(Object o, Object val, ClassMeta componentType) {
        Object[] a = (Object[])o;
        Object[] a2 = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + 1);
        System.arraycopy(a, 0, a2, 0, a.length);
        a2[a.length] = this.convert(val, componentType);
        return a2;
    }

    private static Object[] removeArrayEntry(Object o, int index) {
        Object[] a = (Object[])o;
        Object[] a2 = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length - 1);
        System.arraycopy(a, 0, a2, 0, index);
        System.arraycopy(a, index + 1, a2, index, a.length - index - 1);
        return a2;
    }

    JsonNode getNode(String url, JsonNode n) {
        String parentKey;
        if (url == null || url.isEmpty()) {
            return n;
        }
        int i = url.indexOf(47);
        String childUrl = null;
        if (i == -1) {
            parentKey = url;
        } else {
            parentKey = url.substring(0, i);
            childUrl = url.substring(i + 1);
        }
        Object o = n.o;
        Object o2 = null;
        ClassMeta cm = n.cm;
        ClassMeta<?> ct2 = null;
        if (o == null) {
            return null;
        }
        if (cm.isMap()) {
            o2 = ((Map)o).get(parentKey);
            ct2 = cm.getValueType();
        } else if (cm.isCollection() && o instanceof List) {
            int key = ObjectRest.parseInt(parentKey);
            List l = (List)o;
            if (l.size() <= key) {
                return null;
            }
            o2 = l.get(key);
            ct2 = cm.getElementType();
        } else if (cm.isArray()) {
            Object[] a = (Object[])o;
            int key = ObjectRest.parseInt(parentKey);
            if (a.length <= key) {
                return null;
            }
            o2 = a[key];
            ct2 = cm.getElementType();
        } else if (cm.isBean()) {
            BeanMap<Object> m = this.session.toBeanMap(o);
            o2 = m.get(parentKey);
            BeanPropertyMeta pMeta = m.getPropertyMeta(parentKey);
            if (pMeta == null) {
                throw new ObjectRestException(400, "Unknown property ''{0}'' encountered while trying to parse into class ''{1}''", parentKey, m.getClassMeta());
            }
            ct2 = pMeta.getClassMeta();
        }
        if (childUrl == null) {
            return new JsonNode(n, parentKey, o2, ct2);
        }
        return this.getNode(childUrl, new JsonNode(n, parentKey, o2, ct2));
    }

    private Object convert(Object in, ClassMeta cm) {
        if (cm == null) {
            return in;
        }
        if (cm.isBean() && in instanceof Map) {
            return this.session.convertToType(in, cm);
        }
        return in;
    }

    private static int parseInt(String key) {
        try {
            return Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            throw new ObjectRestException(400, "Cannot address an item in an array with a non-integer key ''{0}''", key);
        }
    }

    class JsonNode {
        Object o;
        ClassMeta cm;
        JsonNode parent;
        String keyName;

        JsonNode(JsonNode parent, String keyName, Object o, ClassMeta cm) {
            this.o = o;
            this.keyName = keyName;
            this.parent = parent;
            if (cm == null || cm.isObject()) {
                cm = o == null ? ObjectRest.this.session.object() : ObjectRest.this.session.getClassMetaForObject(o);
            }
            this.cm = cm;
        }
    }
}

