/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.oapi;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartDataType;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.swaps.TemporalCalendarSwap;
import org.apache.juneau.swaps.TemporalDateSwap;
import org.apache.juneau.swaps.TemporalSwap;
import org.apache.juneau.uon.UonParserSession;

public class OpenApiParserSession
extends UonParserSession {
    private static final BeanContext BC = BeanContext.DEFAULT;
    private static final ClassMeta<Long> CM_Long = BC.getClassMeta(Long.class);
    private static final ClassMeta<Integer> CM_Integer = BC.getClassMeta(Integer.class);
    private static final ClassMeta<Double> CM_Double = BC.getClassMeta(Double.class);
    private static final ClassMeta<Float> CM_Float = BC.getClassMeta(Float.class);
    private static final ClassMeta<Boolean> CM_Boolean = BC.getClassMeta(Boolean.class);
    private static final ClassMeta<JsonList> CM_JsonList = BC.getClassMeta(JsonList.class);
    private static final ClassMeta<JsonMap> CM_JsonMap = BC.getClassMeta(JsonMap.class);
    private static final HttpPartSchema DEFAULT_SCHEMA = HttpPartSchema.DEFAULT;
    private final OpenApiParser ctx;

    public static Builder create(OpenApiParser ctx) {
        return new Builder(ctx);
    }

    protected OpenApiParserSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    @Override
    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, ClassMeta<T> type) throws ParseException, SchemaValidationException {
        Object t;
        if (partType == null) {
            partType = HttpPartType.OTHER;
        }
        boolean isOptional = type.isOptional();
        while (type != null && type.isOptional()) {
            type = type.getElementType();
        }
        if (type == null) {
            type = this.object();
        }
        if ((t = this.parseInner(partType, schema = ObjectUtils.firstNonNull(schema, this.getSchema(), DEFAULT_SCHEMA), in, type)) == null && type.isPrimitive()) {
            t = type.getPrimitiveDefault();
        }
        schema.validateOutput(t, this.ctx.getBeanContext());
        if (isOptional) {
            t = CollectionUtils.optional(t);
        }
        return t;
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        return this.parseInner(null, HttpPartSchema.DEFAULT, pipe.asString(), type);
    }

    private <T> T parseInner(HttpPartType partType, HttpPartSchema schema, String in, ClassMeta<T> type) throws SchemaValidationException, ParseException {
        schema.validateInput(in);
        if (in == null || "null".equals(in)) {
            if (schema.getDefault() == null) {
                return null;
            }
            in = schema.getDefault();
        } else {
            HttpPartFormat f;
            ObjectSwap<T, ?> swap = type.getSwap(this);
            BuilderSwap<T, ?> builder = type.getBuilderSwap(this);
            ClassMeta<Object> sType = null;
            sType = builder != null ? builder.getBuilderClassMeta(this) : (swap != null ? swap.getSwapClassMeta(this) : type);
            if (sType.isOptional()) {
                return (T)CollectionUtils.optional(this.parseInner(partType, schema, in, sType.getElementType()));
            }
            HttpPartDataType t = schema.getType(sType);
            if (partType == null) {
                partType = HttpPartType.OTHER;
            }
            if ((f = schema.getFormat(sType)) == HttpPartFormat.NO_FORMAT) {
                f = this.ctx.getFormat();
            }
            if (t == HttpPartDataType.STRING) {
                if (sType.isObject()) {
                    if (f == HttpPartFormat.BYTE) {
                        return this.toType(StringUtils.base64Decode(in), type);
                    }
                    if (f == HttpPartFormat.DATE || f == HttpPartFormat.DATE_TIME) {
                        return (T)this.toType(StringUtils.parseIsoCalendar(in), type);
                    }
                    if (f == HttpPartFormat.BINARY) {
                        return (T)this.toType(StringUtils.fromHex(in), type);
                    }
                    if (f == HttpPartFormat.BINARY_SPACED) {
                        return (T)this.toType(StringUtils.fromSpacedHex(in), type);
                    }
                    if (f == HttpPartFormat.UON) {
                        return (T)super.parse(partType, schema, in, type);
                    }
                    return (T)this.toType(in, type);
                }
                if (f == HttpPartFormat.BYTE) {
                    return this.toType(StringUtils.base64Decode(in), type);
                }
                if (f == HttpPartFormat.DATE) {
                    try {
                        if (type.isCalendar()) {
                            return (T)this.toType(TemporalCalendarSwap.IsoDate.DEFAULT.unswap((BeanSession)this, in, (ClassMeta)type), type);
                        }
                        if (type.isDate()) {
                            return (T)this.toType(TemporalDateSwap.IsoDate.DEFAULT.unswap((BeanSession)this, in, (ClassMeta)type), type);
                        }
                        if (type.isTemporal()) {
                            return (T)this.toType(TemporalSwap.IsoDate.DEFAULT.unswap((BeanSession)this, in, (ClassMeta)type), type);
                        }
                        return (T)this.toType(in, type);
                    }
                    catch (Exception e) {
                        throw new ParseException(e);
                    }
                }
                if (f == HttpPartFormat.DATE_TIME) {
                    try {
                        if (type.isCalendar()) {
                            return (T)this.toType(TemporalCalendarSwap.IsoDateTime.DEFAULT.unswap((BeanSession)this, in, (ClassMeta)type), type);
                        }
                        if (type.isDate()) {
                            return (T)this.toType(TemporalDateSwap.IsoDateTime.DEFAULT.unswap((BeanSession)this, in, (ClassMeta)type), type);
                        }
                        if (type.isTemporal()) {
                            return (T)this.toType(TemporalSwap.IsoDateTime.DEFAULT.unswap((BeanSession)this, in, (ClassMeta)type), type);
                        }
                        return (T)this.toType(in, type);
                    }
                    catch (Exception e) {
                        throw new ParseException(e);
                    }
                }
                if (f == HttpPartFormat.BINARY) {
                    return (T)this.toType(StringUtils.fromHex(in), type);
                }
                if (f == HttpPartFormat.BINARY_SPACED) {
                    return (T)this.toType(StringUtils.fromSpacedHex(in), type);
                }
                if (f == HttpPartFormat.UON) {
                    return (T)super.parse(partType, schema, in, type);
                }
                return (T)this.toType(in, type);
            }
            if (t == HttpPartDataType.BOOLEAN) {
                if (type.isObject()) {
                    type = CM_Boolean;
                }
                if (type.isBoolean()) {
                    return (T)super.parse(partType, schema, in, type);
                }
                return (T)this.toType(super.parse(partType, schema, in, CM_Boolean), type);
            }
            if (t == HttpPartDataType.INTEGER) {
                if (type.isObject()) {
                    type = f == HttpPartFormat.INT64 ? CM_Long : CM_Integer;
                }
                if (type.isNumber()) {
                    return (T)super.parse(partType, schema, in, type);
                }
                return (T)this.toType(super.parse(partType, schema, in, CM_Integer), type);
            }
            if (t == HttpPartDataType.NUMBER) {
                if (type.isObject()) {
                    type = f == HttpPartFormat.DOUBLE ? CM_Double : CM_Float;
                }
                if (type.isNumber()) {
                    return (T)super.parse(partType, schema, in, type);
                }
                return (T)this.toType(super.parse(partType, schema, in, CM_Double), type);
            }
            if (t == HttpPartDataType.ARRAY) {
                ClassMeta<String> eType;
                HttpPartCollectionFormat cf = schema.getCollectionFormat();
                if (cf == HttpPartCollectionFormat.NO_COLLECTION_FORMAT) {
                    cf = this.ctx.getCollectionFormat();
                }
                if (cf == HttpPartCollectionFormat.UONC) {
                    return (T)super.parse(partType, schema, in, type);
                }
                if (type.isObject()) {
                    type = CM_JsonList;
                }
                ClassMeta<String> classMeta = eType = type.isObject() ? this.string() : type.getElementType();
                if (eType == null) {
                    eType = schema.getParsedType().getElementType();
                }
                if (eType == null) {
                    eType = this.string();
                }
                String[] ss = new String[]{};
                if (cf == HttpPartCollectionFormat.MULTI) {
                    ss = new String[]{in};
                } else if (cf == HttpPartCollectionFormat.CSV) {
                    ss = StringUtils.split(in, ',');
                } else if (cf == HttpPartCollectionFormat.PIPES) {
                    ss = StringUtils.split(in, '|');
                } else if (cf == HttpPartCollectionFormat.SSV) {
                    ss = StringUtils.splitQuoted(in);
                } else if (cf == HttpPartCollectionFormat.TSV) {
                    ss = StringUtils.split(in, '\t');
                } else {
                    if (cf == HttpPartCollectionFormat.UONC) {
                        return (T)super.parse(partType, null, in, type);
                    }
                    if (cf == HttpPartCollectionFormat.NO_COLLECTION_FORMAT) {
                        if (StringUtils.firstNonWhitespaceChar(in) == '@' && StringUtils.lastNonWhitespaceChar(in) == ')') {
                            return (T)super.parse(partType, null, in, type);
                        }
                        ss = StringUtils.split(in, ',');
                    }
                }
                HttpPartSchema items = schema.getItems();
                if (items == null) {
                    items = HttpPartSchema.DEFAULT;
                }
                Object o = Array.newInstance(eType.getInnerClass(), ss.length);
                for (int i = 0; i < ss.length; ++i) {
                    Array.set(o, i, this.parse(partType, items, ss[i], eType));
                }
                if (type.hasMutaterFrom(schema.getParsedType()) || schema.getParsedType().hasMutaterTo(type)) {
                    return (T)this.toType(this.toType(o, schema.getParsedType()), type);
                }
                return (T)this.toType(o, type);
            }
            if (t == HttpPartDataType.OBJECT) {
                ClassMeta<String> eType;
                HttpPartCollectionFormat cf = schema.getCollectionFormat();
                if (cf == HttpPartCollectionFormat.NO_COLLECTION_FORMAT) {
                    cf = this.ctx.getCollectionFormat();
                }
                if (cf == HttpPartCollectionFormat.UONC) {
                    return (T)super.parse(partType, schema, in, type);
                }
                if (type.isObject()) {
                    type = CM_JsonMap;
                }
                if (!type.isMapOrBean()) {
                    throw new ParseException("Invalid type {0} for part type OBJECT.", type);
                }
                String[] ss = new String[]{};
                if (cf == HttpPartCollectionFormat.MULTI) {
                    ss = new String[]{in};
                } else if (cf == HttpPartCollectionFormat.CSV) {
                    ss = StringUtils.split(in, ',');
                } else if (cf == HttpPartCollectionFormat.PIPES) {
                    ss = StringUtils.split(in, '|');
                } else if (cf == HttpPartCollectionFormat.SSV) {
                    ss = StringUtils.splitQuoted(in);
                } else if (cf == HttpPartCollectionFormat.TSV) {
                    ss = StringUtils.split(in, '\t');
                } else {
                    if (cf == HttpPartCollectionFormat.UONC) {
                        return (T)super.parse(partType, null, in, type);
                    }
                    if (cf == HttpPartCollectionFormat.NO_COLLECTION_FORMAT) {
                        if (StringUtils.firstNonWhitespaceChar(in) == '@' && StringUtils.lastNonWhitespaceChar(in) == ')') {
                            return (T)super.parse(partType, null, in, type);
                        }
                        ss = StringUtils.split(in, ',');
                    }
                }
                if (type.isBean()) {
                    BeanMap<Object> m = this.ctx.getBeanContext().newBeanMap(type.getInnerClass());
                    for (String s : ss) {
                        String[] kv = StringUtils.split(s, '=', 2);
                        if (kv.length != 2) {
                            throw new ParseException("Invalid input {0} for part type OBJECT.", in);
                        }
                        String key = kv[0];
                        String value = kv[1];
                        BeanPropertyMeta bpm = m.getPropertyMeta(key);
                        if (bpm == null && !this.isIgnoreUnknownBeanProperties()) {
                            throw new ParseException("Invalid input {0} for part type OBJECT.  Cannot find property {1}", in, key);
                        }
                        m.put(key, this.parse(partType, schema.getProperty(key), value, bpm == null ? this.object() : bpm.getClassMeta()));
                    }
                    return (T)m.getBean();
                }
                ClassMeta<String> classMeta = eType = type.isObject() ? this.string() : type.getValueType();
                if (eType == null) {
                    eType = schema.getParsedType().getValueType();
                }
                if (eType == null) {
                    eType = this.string();
                }
                try {
                    Map m = (Map)type.newInstance();
                    if (m == null) {
                        m = JsonMap.create();
                    }
                    for (String s : ss) {
                        String[] kv = StringUtils.split(s, '=', 2);
                        if (kv.length != 2) {
                            throw new ParseException("Invalid input {0} for part type OBJECT.", in);
                        }
                        String key = kv[0];
                        String value = kv[1];
                        m.put(key, this.parse(partType, schema.getProperty(key), value, eType));
                    }
                    return (T)m;
                }
                catch (ExecutableException e) {
                    throw new ParseException(e);
                }
            }
            if (t == HttpPartDataType.FILE) {
                throw new ParseException("File part not supported.", new Object[0]);
            }
            if (t == HttpPartDataType.NO_TYPE) {
                throw new ParseException("Invalid type.", new Object[0]);
            }
        }
        return super.parse(partType, schema, in, type);
    }

    private <T> T toType(Object in, ClassMeta<T> type) throws ParseException {
        try {
            return this.convertToType(in, type);
        }
        catch (InvalidDataConversionException e) {
            throw new ParseException(e.getMessage(), new Object[0]);
        }
    }

    @FluentSetters
    public static class Builder
    extends UonParserSession.Builder {
        OpenApiParser ctx;

        protected Builder(OpenApiParser ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public OpenApiParserSession build() {
            return new OpenApiParserSession(this);
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder decoding(boolean value) {
            super.decoding(value);
            return this;
        }
    }
}

