/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.InputStreamEntity;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.http.resource.HttpResourceBuilder;

@BeanIgnore
public class BasicResource
implements HttpResource {
    final BasicHttpEntity entity;
    final HeaderList headers;

    public static <T extends BasicResource> HttpResourceBuilder<T> create(Class<T> implClass, Class<? extends BasicHttpEntity> entityImplClass) {
        return new HttpResourceBuilder<T>(implClass, entityImplClass);
    }

    public BasicResource(HttpResourceBuilder<?> builder) {
        this.entity = builder.entity();
        this.headers = builder.headers();
    }

    public BasicResource(HttpResponse response) throws IOException {
        this(BasicResource.create(null, InputStreamEntity.class).copyFrom(response));
    }

    public HttpResourceBuilder<? extends BasicResource> copy() {
        return new HttpResourceBuilder<BasicResource>(this);
    }

    public String asString() throws IOException {
        return this.entity.asString();
    }

    public byte[] asBytes() throws IOException {
        return this.entity.asBytes();
    }

    public FluentStringAssertion<BasicResource> assertString() throws IOException {
        return new FluentStringAssertion<BasicResource>(this.asString(), this);
    }

    public FluentByteArrayAssertion<BasicResource> assertBytes() throws IOException {
        return new FluentByteArrayAssertion<BasicResource>(this.asBytes(), this);
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public boolean isChunked() {
        return this.entity.isChunked();
    }

    public Header getContentType() {
        return this.entity.getContentType();
    }

    public Header getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public boolean isStreaming() {
        return this.entity.isStreaming();
    }

    public void consumeContent() throws IOException {
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.entity.getContent();
    }

    public void writeTo(OutputStream outStream) throws IOException {
        this.entity.writeTo(outStream);
    }

    @Override
    public HeaderList getHeaders() {
        return this.headers;
    }
}

