/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Supplier;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.resource.ByteArrayResource;
import org.apache.juneau.http.resource.FileResource;
import org.apache.juneau.http.resource.HttpResourceBuilder;
import org.apache.juneau.http.resource.InputStreamResource;
import org.apache.juneau.http.resource.ReaderResource;
import org.apache.juneau.http.resource.StringResource;

public class HttpResources {
    public static final HttpResourceBuilder<ByteArrayResource> byteArrayResource(byte[] content) {
        return ByteArrayResource.create().content(content);
    }

    public static final HttpResourceBuilder<ByteArrayResource> byteArrayResource(byte[] content, ContentType contentType) {
        return ByteArrayResource.create().content(content).contentType(contentType);
    }

    public static final HttpResourceBuilder<ByteArrayResource> byteArrayResource(Supplier<byte[]> content) {
        return ByteArrayResource.create().content(content);
    }

    public static final HttpResourceBuilder<ByteArrayResource> byteArrayResource(Supplier<byte[]> content, ContentType contentType) {
        return ByteArrayResource.create().content(content).contentType(contentType);
    }

    public static final HttpResourceBuilder<FileResource> fileResource(File content) {
        return FileResource.create().content(content);
    }

    public static final HttpResourceBuilder<FileResource> fileResource(File content, ContentType contentType) {
        return FileResource.create().content(content).contentType(contentType);
    }

    public static final HttpResourceBuilder<ReaderResource> readerResource(Reader content) {
        return ReaderResource.create().content(content);
    }

    public static final HttpResourceBuilder<ReaderResource> readerResource(Reader content, ContentType contentType) {
        return ReaderResource.create().content(content).contentType(contentType);
    }

    public static final HttpResourceBuilder<InputStreamResource> streamResource(InputStream content) {
        return InputStreamResource.create().content(content);
    }

    public static final HttpResourceBuilder<InputStreamResource> streamResource(InputStream content, long length, ContentType contentType) {
        return InputStreamResource.create().content(content).contentLength(length).contentType(contentType);
    }

    public static final HttpResourceBuilder<StringResource> stringResource(String content) {
        return StringResource.create().content(content);
    }

    public static final HttpResourceBuilder<StringResource> stringResource(String content, ContentType contentType) {
        return StringResource.create().content(content).contentType(contentType);
    }

    public static final HttpResourceBuilder<StringResource> stringResource(Supplier<String> content) {
        return StringResource.create().content(content);
    }

    public static final HttpResourceBuilder<StringResource> stringResource(Supplier<String> content, ContentType contentType) {
        return StringResource.create().content(content).contentType(contentType);
    }
}

