/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Locale;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.http.StatusLine;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.message.BasicLineFormatter;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;

public class BasicStatusLine
implements StatusLine {
    private ProtocolVersion DEFAULT_PROTOCOL_VERSION = new ProtocolVersion("HTTP", 1, 1);
    final ProtocolVersion protocolVersion;
    final int statusCode;
    final String reasonPhrase;
    final Locale locale;

    public static Builder create() {
        return new Builder();
    }

    public BasicStatusLine(Builder builder) {
        this.protocolVersion = ObjectUtils.firstNonNull(builder.protocolVersion, this.DEFAULT_PROTOCOL_VERSION);
        this.statusCode = ObjectUtils.firstNonNull(builder.statusCode, 0);
        this.locale = ObjectUtils.firstNonNull(builder.locale, Locale.getDefault());
        String reasonPhrase = builder.reasonPhrase;
        if (reasonPhrase == null) {
            ReasonPhraseCatalog rfc = ObjectUtils.firstNonNull(builder.reasonPhraseCatalog, EnglishReasonPhraseCatalog.INSTANCE);
            reasonPhrase = rfc.getReason(this.statusCode, this.locale);
        }
        this.reasonPhrase = reasonPhrase;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatStatusLine(null, (StatusLine)this).toString();
    }

    @FluentSetters
    public static class Builder {
        ProtocolVersion protocolVersion;
        Integer statusCode;
        String reasonPhrase;
        Locale locale;
        ReasonPhraseCatalog reasonPhraseCatalog;

        protected Builder() {
        }

        protected Builder(BasicStatusLine copyFrom) {
            this.protocolVersion = copyFrom.protocolVersion;
            this.statusCode = copyFrom.statusCode;
            this.reasonPhrase = copyFrom.reasonPhrase;
            this.locale = copyFrom.locale;
        }

        public BasicStatusLine build() {
            return new BasicStatusLine(this);
        }

        @FluentSetter
        public Builder protocolVersion(ProtocolVersion value) {
            this.protocolVersion = value;
            return this;
        }

        @FluentSetter
        public Builder statusCode(int value) {
            this.statusCode = value;
            return this;
        }

        @FluentSetter
        public Builder reasonPhrase(String value) {
            this.reasonPhrase = value;
            return this;
        }

        @FluentSetter
        public Builder reasonPhraseCatalog(ReasonPhraseCatalog value) {
            this.reasonPhraseCatalog = value;
            return this;
        }

        @FluentSetter
        public Builder locale(Locale value) {
            this.locale = value;
            return this;
        }
    }
}

