/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;

public final class HttpRuntimeException
extends BasicRuntimeException {
    private static final long serialVersionUID = 1L;
    final Throwable t;

    public HttpRuntimeException(Throwable t) {
        super(t, t == null ? "" : t.getMessage(), new Object[0]);
        this.t = t;
    }

    public Throwable getInner() {
        return this.t;
    }

    public static RuntimeException toHttpException(Throwable t, Class<?> ec) {
        return HttpRuntimeException.toHttpException(t, ec, null, new Object[0]);
    }

    public static RuntimeException toHttpException(Throwable t, Class<?> ec, String msg, Object ... args) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getCause();
        }
        if (t instanceof ExecutableException) {
            t = ((ExecutableException)t).getTargetException();
        }
        if (t instanceof ParseException) {
            throw new BadRequest(t);
        }
        ClassInfo ci = ClassInfo.of(t);
        if (ci.isRuntimeException() && (ci.hasAnnotation(Response.class) || ci.isChildOf(BasicHttpException.class))) {
            return (RuntimeException)t;
        }
        if (ci.hasAnnotation(Response.class)) {
            return new HttpRuntimeException(t);
        }
        if (ec == null) {
            ec = InternalServerError.class;
        }
        ClassInfo eci = ClassInfo.of(ec);
        try {
            ConstructorInfo cci = eci.getPublicConstructor(x -> x.hasParamTypes(Throwable.class, String.class, Object[].class));
            if (cci != null) {
                return HttpRuntimeException.toHttpException((Throwable)cci.invoke(t, msg, args), InternalServerError.class);
            }
            cci = eci.getPublicConstructor(x -> x.hasParamTypes(Throwable.class));
            if (cci != null) {
                return HttpRuntimeException.toHttpException((Throwable)cci.invoke(t), InternalServerError.class);
            }
            System.err.println("WARNING:  Class '" + ec + "' does not have a public constructor that takes in valid arguments.");
            return new InternalServerError(t);
        }
        catch (ExecutableException e) {
            throw new InternalServerError(e.getCause());
        }
    }
}

