/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StateMachineState;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.objecttools.AbstractMatcher;
import org.apache.juneau.objecttools.Equality;
import org.apache.juneau.objecttools.MatcherFactory;
import org.apache.juneau.objecttools.PatternException;

public class TimeMatcherFactory
extends MatcherFactory {
    public static final TimeMatcherFactory DEFAULT = new TimeMatcherFactory();
    private final SimpleDateFormat[] formats = this.getTimestampFormats();

    protected TimeMatcherFactory() {
    }

    protected SimpleDateFormat[] getTimestampFormats() {
        String[] s = this.getTimestampFormatStrings();
        SimpleDateFormat[] a = new SimpleDateFormat[s.length];
        for (int i = 0; i < s.length; ++i) {
            a[i] = new SimpleDateFormat(s[i]);
        }
        return a;
    }

    protected String[] getTimestampFormatStrings() {
        return new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
    }

    @Override
    public boolean canMatch(ClassMeta<?> cm) {
        return cm.isDateOrCalendar();
    }

    @Override
    public AbstractMatcher create(String pattern) {
        return new TimeMatcher(this.formats, pattern);
    }

    private static int getPrecisionField(String pattern) {
        if (pattern.indexOf(115) != -1) {
            return 13;
        }
        if (pattern.indexOf(109) != -1) {
            return 12;
        }
        if (pattern.indexOf(72) != -1) {
            return 11;
        }
        if (pattern.indexOf(100) != -1) {
            return 5;
        }
        if (pattern.indexOf(77) != -1) {
            return 2;
        }
        if (pattern.indexOf(121) != -1) {
            return 1;
        }
        return 14;
    }

    static CalendarP parseDate(SimpleDateFormat[] formats, String seg) {
        ParsePosition pp = new ParsePosition(0);
        for (int i = 0; i < formats.length; ++i) {
            char c;
            SimpleDateFormat f = formats[i];
            Date d = f.parse(seg, pp);
            int idx = pp.getIndex();
            if (idx == 0) continue;
            char c2 = c = seg.length() == idx ? (char)'\u0000' : seg.charAt(idx);
            if (c != '\u0000' && c != '-' && !Character.isWhitespace(c)) continue;
            return new CalendarP(d, TimeMatcherFactory.getPrecisionField(f.toPattern()));
        }
        throw ThrowableUtils.runtimeException("Invalid date encountered:  ''{0}''", seg);
    }

    private static class CalendarP {
        public Calendar c = Calendar.getInstance();
        public int precision;

        public CalendarP(Date date, int precision) {
            this.c.setTime(date);
            this.precision = precision;
        }

        public CalendarP copy() {
            return new CalendarP(this.c.getTime(), this.precision);
        }

        public CalendarP roll(int field, int amount) {
            this.c.add(field, amount);
            return this;
        }

        public CalendarP roll(int amount) {
            return this.roll(this.precision, amount);
        }

        public Calendar getCalendar() {
            return this.c;
        }
    }

    private static class TimestampRange {
        Calendar start;
        Calendar end;

        public TimestampRange(SimpleDateFormat[] formats, String start, String end) {
            CalendarP start1 = TimeMatcherFactory.parseDate(formats, start);
            CalendarP end1 = TimeMatcherFactory.parseDate(formats, end);
            this.start = start1.copy().roll(14, -1).getCalendar();
            this.end = end1.roll(1).getCalendar();
        }

        public TimestampRange(SimpleDateFormat[] formats, Equality eq, String singleDate) {
            CalendarP singleDate1 = TimeMatcherFactory.parseDate(formats, singleDate);
            if (eq == Equality.GT) {
                this.start = singleDate1.roll(1).roll(14, -1).getCalendar();
                this.end = new CalendarP(new Date(Long.MAX_VALUE), 0).getCalendar();
            } else if (eq == Equality.LT) {
                this.start = new CalendarP(new Date(0L), 0).getCalendar();
                this.end = singleDate1.getCalendar();
            } else if (eq == Equality.GTE) {
                this.start = singleDate1.roll(14, -1).getCalendar();
                this.end = new CalendarP(new Date(Long.MAX_VALUE), 0).getCalendar();
            } else if (eq == Equality.LTE) {
                this.start = new CalendarP(new Date(0L), 0).getCalendar();
                this.end = singleDate1.roll(1).getCalendar();
            } else {
                this.start = singleDate1.copy().roll(14, -1).getCalendar();
                this.end = singleDate1.roll(1).getCalendar();
            }
        }

        public boolean matches(Calendar c) {
            boolean b = c.after(this.start) && c.before(this.end);
            return b;
        }
    }

    private static class TimeMatcher
    extends AbstractMatcher {
        private static final AsciiSet DT = AsciiSet.create("0123456789-:T./");
        private static final AsciiSet WS = AsciiSet.create(" \t");
        TimestampRange[] ranges;
        List<TimestampRange> l = new LinkedList<TimestampRange>();

        public TimeMatcher(SimpleDateFormat[] f, String s) {
            int i;
            StateMachineState state = StateMachineState.S01;
            int mark = 0;
            Equality eq = Equality.NONE;
            String s1 = null;
            String s2 = null;
            char c = '\u0000';
            for (i = 0; i < s.trim().length(); ++i) {
                c = s.charAt(i);
                if (state == StateMachineState.S01) {
                    if (WS.contains(c)) {
                        state = StateMachineState.S01;
                        continue;
                    }
                    if (c == '>') {
                        state = StateMachineState.S02;
                        eq = Equality.GT;
                        continue;
                    }
                    if (c == '<') {
                        state = StateMachineState.S03;
                        eq = Equality.LT;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateMachineState.S05;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateMachineState.S06;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateMachineState.S08;
                    mark = i;
                    continue;
                }
                if (state == StateMachineState.S02) {
                    if (WS.contains(c)) {
                        state = StateMachineState.S02;
                        continue;
                    }
                    if (c == '=') {
                        state = StateMachineState.S04;
                        eq = Equality.GTE;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateMachineState.S05;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateMachineState.S06;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateMachineState.S08;
                    mark = i;
                    continue;
                }
                if (state == StateMachineState.S03) {
                    if (WS.contains(c)) {
                        state = StateMachineState.S03;
                        continue;
                    }
                    if (c == '=') {
                        state = StateMachineState.S04;
                        eq = Equality.LTE;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateMachineState.S05;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateMachineState.S06;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateMachineState.S08;
                    mark = i;
                    continue;
                }
                if (state == StateMachineState.S04) {
                    if (WS.contains(c)) {
                        state = StateMachineState.S04;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateMachineState.S05;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateMachineState.S06;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateMachineState.S08;
                    mark = i;
                    continue;
                }
                if (state == StateMachineState.S05) {
                    if (c != '\'') continue;
                    state = StateMachineState.S07;
                    s1 = s.substring(mark, i);
                    continue;
                }
                if (state == StateMachineState.S06) {
                    if (c != '\"') continue;
                    state = StateMachineState.S07;
                    s1 = s.substring(mark, i);
                    continue;
                }
                if (state == StateMachineState.S07) {
                    if (WS.contains(c)) {
                        state = StateMachineState.S09;
                        continue;
                    }
                    if (c != '-') break;
                    state = StateMachineState.S10;
                    continue;
                }
                if (state == StateMachineState.S08) {
                    if (!WS.contains(c)) continue;
                    state = StateMachineState.S09;
                    s1 = s.substring(mark, i);
                    continue;
                }
                if (state == StateMachineState.S09) {
                    if (WS.contains(c)) {
                        state = StateMachineState.S09;
                        continue;
                    }
                    if (c == '-') {
                        state = StateMachineState.S10;
                        continue;
                    }
                    if (c == '>') {
                        state = StateMachineState.S02;
                        this.l.add(new TimestampRange(f, eq, s1));
                        eq = Equality.GT;
                        s1 = null;
                        continue;
                    }
                    if (c == '<') {
                        state = StateMachineState.S03;
                        this.l.add(new TimestampRange(f, eq, s1));
                        eq = Equality.LT;
                        s1 = null;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateMachineState.S05;
                        this.l.add(new TimestampRange(f, eq, s1));
                        mark = i + 1;
                        eq = null;
                        s1 = null;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateMachineState.S06;
                        this.l.add(new TimestampRange(f, eq, s1));
                        mark = i + 1;
                        eq = null;
                        s1 = null;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateMachineState.S08;
                    this.l.add(new TimestampRange(f, eq, s1));
                    eq = null;
                    s1 = null;
                    mark = i;
                    continue;
                }
                if (state == StateMachineState.S10) {
                    if (WS.contains(c)) {
                        state = StateMachineState.S10;
                        continue;
                    }
                    if (c == '\'') {
                        state = StateMachineState.S11;
                        mark = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = StateMachineState.S12;
                        mark = i + 1;
                        continue;
                    }
                    if (!DT.contains(c)) break;
                    state = StateMachineState.S13;
                    mark = i;
                    continue;
                }
                if (state == StateMachineState.S11) {
                    if (c != '\'') continue;
                    state = StateMachineState.S01;
                    s2 = s.substring(mark, i);
                    this.l.add(new TimestampRange(f, s1, s2));
                    s1 = null;
                    s2 = null;
                    continue;
                }
                if (state == StateMachineState.S12) {
                    if (c != '\"') continue;
                    state = StateMachineState.S01;
                    s2 = s.substring(mark, i);
                    this.l.add(new TimestampRange(f, s1, s2));
                    s1 = null;
                    s2 = null;
                    continue;
                }
                if (!WS.contains(c)) continue;
                state = StateMachineState.S01;
                s2 = s.substring(mark, i);
                this.l.add(new TimestampRange(f, s1, s2));
                s1 = null;
                s2 = null;
            }
            if (i != s.length()) {
                throw new PatternException("Invalid range pattern ({0}): pattern=[{1}], pos=[{2}], char=[{3}]", new Object[]{state, s, i, Character.valueOf(c)});
            }
            if (state != StateMachineState.S01) {
                if (state == StateMachineState.S02 || state == StateMachineState.S03 || state == StateMachineState.S04 || state == StateMachineState.S05 || state == StateMachineState.S06 || state == StateMachineState.S10 || state == StateMachineState.S11 || state == StateMachineState.S12) {
                    throw new PatternException("Invalid range pattern (E{0}): {1}", new Object[]{state, s});
                }
                if (state == StateMachineState.S07) {
                    this.l.add(new TimestampRange(f, eq, s1));
                } else if (state == StateMachineState.S08) {
                    s1 = s.substring(mark).trim();
                    this.l.add(new TimestampRange(f, eq, s1));
                } else {
                    s2 = s.substring(mark).trim();
                    this.l.add(new TimestampRange(f, s1, s2));
                }
            }
            this.ranges = this.l.toArray(new TimestampRange[this.l.size()]);
        }

        @Override
        public boolean matches(ClassMeta<?> cm, Object o) {
            if (this.ranges.length == 0) {
                return true;
            }
            Calendar c = null;
            if (cm.isCalendar()) {
                c = (Calendar)o;
            } else {
                c = Calendar.getInstance();
                c.setTime((Date)o);
            }
            for (int i = 0; i < this.ranges.length; ++i) {
                if (!this.ranges[i].matches(c)) continue;
                return true;
            }
            return false;
        }
    }
}

