/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class FileUtils {
    public static File mkdirs(File f, boolean clean) {
        Assertions.assertArgNotNull("f", f);
        if (f.exists()) {
            if (clean) {
                if (!FileUtils.delete(f)) {
                    throw ThrowableUtils.runtimeException("Could not clean directory ''{0}''", f.getAbsolutePath());
                }
            } else {
                return f;
            }
        }
        if (!f.mkdirs()) {
            throw ThrowableUtils.runtimeException("Could not create directory ''{0}''", f.getAbsolutePath());
        }
        return f;
    }

    public static File mkdirs(String path, boolean clean) {
        Assertions.assertArgNotNull("path", path);
        return FileUtils.mkdirs(new File(path), clean);
    }

    public static boolean delete(File f) {
        File[] cf;
        if (f == null) {
            return true;
        }
        if (f.isDirectory() && (cf = f.listFiles()) != null) {
            for (File c : cf) {
                FileUtils.delete(c);
            }
        }
        return f.delete();
    }

    public static void create(File f) {
        if (f.exists()) {
            return;
        }
        try {
            if (!f.createNewFile()) {
                throw ThrowableUtils.runtimeException("Could not create file ''{0}''", f.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    public static void modifyTimestamp(File f) {
        long l;
        long lm = f.lastModified();
        if (lm == (l = System.currentTimeMillis())) {
            ++l;
        }
        if (!f.setLastModified(l)) {
            throw ThrowableUtils.runtimeException("Could not modify timestamp on file ''{0}''", f.getAbsolutePath());
        }
        if (lm == f.lastModified() && !f.setLastModified(l += 1000L)) {
            throw ThrowableUtils.runtimeException("Could not modify timestamp on file ''{0}''", f.getAbsolutePath());
        }
    }

    public static File createTempFile(String name) throws IOException {
        String[] parts = name.split("\\.");
        File f = File.createTempFile(parts[0], "." + parts[1]);
        f.deleteOnExit();
        return f;
    }

    public static String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static String getExtension(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1);
    }

    public static boolean exists(File dir, String fileName) {
        if (dir == null || fileName == null) {
            return false;
        }
        return Files.exists(dir.toPath().resolve(fileName), new LinkOption[0]);
    }

    public static boolean hasExtension(String name, String ext) {
        if (name == null || ext == null) {
            return false;
        }
        return ext.equals(FileUtils.getExtension(name));
    }

    public static String getFileName(String path) {
        if (StringUtils.isEmpty(path)) {
            return null;
        }
        int i = (path = StringUtils.trimTrailingSlashes(path)).lastIndexOf(47);
        return i == -1 ? path : path.substring(i + 1);
    }
}

