/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.AssertionPredicate;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;

@FluentSetters(returns="FluentObjectAssertion<T,R>")
public class FluentObjectAssertion<T, R>
extends FluentAssertion<R> {
    private static final Messages MESSAGES = Messages.of(FluentObjectAssertion.class, "Messages");
    private static final String MSG_unexpectedType = MESSAGES.getString("unexpectedType");
    private static final String MSG_unexpectedComparison = MESSAGES.getString("unexpectedComparison");
    private static final String MSG_unexpectedValue = MESSAGES.getString("unexpectedValue");
    private static final String MSG_unexpectedValueDidNotExpect = MESSAGES.getString("unexpectedValueDidNotExpect");
    private static final String MSG_notTheSameValue = MESSAGES.getString("notTheSameValue");
    private static final String MSG_valueWasNull = MESSAGES.getString("valueWasNull");
    private static final String MSG_valueWasNotNull = MESSAGES.getString("valueWasNotNull");
    private static final String MSG_expectedValueNotFound = MESSAGES.getString("expectedValueNotFound");
    private static final String MSG_unexpectedValueFound = MESSAGES.getString("unexpectedValueFound");
    private static final String MSG_unexpectedValue2 = MESSAGES.getString("unexpectedValue2");
    private static JsonSerializer JSON = JsonSerializer.create().ssq().build();
    private static JsonSerializer JSON_SORTED = JsonSerializer.create().ssq().sortProperties().sortCollections().sortMaps().build();
    private final T value;

    public FluentObjectAssertion(T value, R returns) {
        this(null, value, returns);
    }

    public FluentObjectAssertion(Assertion creator, T value, R returns) {
        super(creator, returns);
        this.value = value;
    }

    public FluentStringAssertion<R> asString() {
        return new FluentStringAssertion((Assertion)this, this.valueAsString(), this.returns());
    }

    public FluentStringAssertion<R> asString(WriterSerializer ws) {
        try {
            return new FluentStringAssertion((Assertion)this, ws.serialize(this.value), this.returns());
        }
        catch (SerializeException e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    public FluentStringAssertion<R> asString(Function<T, String> function) {
        return new FluentStringAssertion((Assertion)this, function.apply(this.value), this.returns());
    }

    public FluentStringAssertion<R> asJson() {
        return this.asString(JSON);
    }

    public FluentStringAssertion<R> asJsonSorted() {
        return this.asString(JSON_SORTED);
    }

    public FluentObjectAssertion<T, R> asTransformed(Function<T, T> function) {
        return new FluentObjectAssertion(this, function.apply(this.orElse(null)), this.returns());
    }

    public <T2> FluentObjectAssertion<T2, R> asTransformedTo(Function<T, T2> function) {
        return new FluentObjectAssertion(this, function.apply(this.orElse(null)), this.returns());
    }

    public FluentAnyAssertion<T, R> asAny() {
        return new FluentAnyAssertion(this, this.orElse(null), this.returns());
    }

    public R isExists() throws AssertionError {
        return this.isNotNull();
    }

    public R isNull() throws AssertionError {
        if (this.value != null) {
            throw this.error(MSG_valueWasNotNull, new Object[0]);
        }
        return this.returns();
    }

    public R isNotNull() throws AssertionError {
        if (this.value == null) {
            throw this.error(MSG_valueWasNull, new Object[0]);
        }
        return this.returns();
    }

    public R is(T value) throws AssertionError {
        if (this.value == value) {
            return this.returns();
        }
        if (!this.equals(this.orElse(null), value)) {
            throw this.error(MSG_unexpectedValue, value, this.value);
        }
        return this.returns();
    }

    public R isString(String value) {
        return this.asString().is(value);
    }

    public R isNot(T value) throws AssertionError {
        if (this.equals(this.orElse(null), value)) {
            throw this.error(MSG_unexpectedValueDidNotExpect, value, this.orElse(null));
        }
        return this.returns();
    }

    public R isAny(T ... values) throws AssertionError {
        for (T v : values) {
            if (!this.equals(this.orElse(null), v)) continue;
            return this.returns();
        }
        throw this.error(MSG_expectedValueNotFound, values, this.value);
    }

    public R isNotAny(T ... values) throws AssertionError {
        for (T v : values) {
            if (!this.equals(this.orElse(null), v)) continue;
            throw this.error(MSG_unexpectedValueFound, v, this.value);
        }
        return this.returns();
    }

    public R isSame(T value) throws AssertionError {
        if (this.value == value) {
            return this.returns();
        }
        throw this.error(MSG_notTheSameValue, value, ObjectUtils.identity(value), this.value, ObjectUtils.identity(this.value));
    }

    public R isSameJsonAs(Object o) throws AssertionError {
        return this.isSameSerializedAs(o, JSON);
    }

    public R isSameSortedJsonAs(Object o) {
        return this.isSameSerializedAs(o, JSON_SORTED);
    }

    public R isSameSerializedAs(Object o, WriterSerializer serializer) {
        String s2;
        String s1 = serializer.toString(this.value);
        if (StringUtils.ne(s1, s2 = serializer.toString(o))) {
            throw this.error(MSG_unexpectedComparison, s2, s1);
        }
        return this.returns();
    }

    public R isType(Class<?> parent) throws AssertionError {
        Assertions.assertArgNotNull("parent", parent);
        if (!ClassInfo.of(this.value()).isChildOf(parent)) {
            throw this.error(MSG_unexpectedType, FluentObjectAssertion.className(parent), FluentObjectAssertion.className(this.value));
        }
        return this.returns();
    }

    public R isExactType(Class<?> type) throws AssertionError {
        Assertions.assertArgNotNull("parent", type);
        if (this.value().getClass() != type) {
            throw this.error(MSG_unexpectedType, FluentObjectAssertion.className(type), FluentObjectAssertion.className(this.value));
        }
        return this.returns();
    }

    public R is(Predicate<T> test) throws AssertionError {
        if (test != null && !test.test(this.value)) {
            throw this.error(this.getFailureMessage(test, this.value), new Object[0]);
        }
        return this.returns();
    }

    public R isJson(String value) {
        return this.asJson().is(value);
    }

    @Override
    public FluentObjectAssertion<T, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentObjectAssertion<T, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentObjectAssertion<T, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentObjectAssertion<T, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentObjectAssertion<T, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    protected T value() throws AssertionError {
        this.isExists();
        return this.value;
    }

    protected String valueAsString() {
        return StringUtils.stringify(this.value);
    }

    protected T orElse(T other) {
        return this.value == null ? other : this.value;
    }

    protected boolean valueIsNull() {
        return this.value == null;
    }

    protected boolean valueIsNotNull() {
        return this.value != null;
    }

    protected Optional<T> opt() {
        return CollectionUtils.optional(this.value);
    }

    protected <T2> Optional<T2> map(Function<? super T, ? extends T2> mapper) {
        return this.opt().map(mapper);
    }

    protected String getFailureMessage(Predicate<?> p, Object value) {
        if (p instanceof AssertionPredicate) {
            return ((AssertionPredicate)p).getFailureMessage();
        }
        return StringUtils.format(MSG_unexpectedValue2, value);
    }

    protected boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray()) {
            return StringUtils.stringifyDeep(o1).equals(StringUtils.stringifyDeep(o2));
        }
        return false;
    }

    public String toString() {
        return this.valueAsString();
    }
}

