/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.html5;

import java.util.LinkedList;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.dto.html5.HtmlBeanDictionary;
import org.apache.juneau.dto.html5.HtmlElement;
import org.apache.juneau.dto.html5.HtmlElementMixed;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class HtmlElementContainer
extends HtmlElement {
    private LinkedList<Object> children;

    @Xml(format=XmlFormat.ELEMENTS)
    @Beanp(dictionary={HtmlBeanDictionary.class}, name="c")
    public LinkedList<Object> getChildren() {
        return this.children;
    }

    @Beanp(value="c")
    public HtmlElementContainer setChildren(LinkedList<Object> children) {
        this.children = children;
        return this;
    }

    public Object getChild(int index) {
        return this.children == null || this.children.size() <= index || index < 0 ? null : this.children.get(index);
    }

    public Object getChild(int ... index) {
        if (index.length == 0) {
            return null;
        }
        if (index.length == 1) {
            return this.getChild(index[0]);
        }
        Object c = this;
        for (int i = 0; i < index.length; ++i) {
            if (c instanceof HtmlElementMixed) {
                c = ((HtmlElementMixed)c).getChild(index[i]);
                continue;
            }
            if (c instanceof HtmlElementContainer) {
                c = ((HtmlElementContainer)c).getChild(index[i]);
                continue;
            }
            return null;
        }
        return c;
    }

    public <T> T getChild(Class<T> type, int index) {
        return this.children == null || this.children.size() <= index || index < 0 ? null : (T)ConverterUtils.toType(this.children.get(index), type);
    }

    public HtmlElement children(Object ... children) {
        if (children.length > 0) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            for (Object c : children) {
                this.children.add(c);
            }
        }
        return this;
    }

    public HtmlElement child(Object child) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(child);
        return this;
    }
}

