/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.Writable;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.IOUtils;

@Response
public class ReaderResource
implements Writable {
    private final MediaType mediaType;
    private final Map<String, Object> headers;
    protected final Object[] contents;

    protected ReaderResource(Builder b) throws IOException {
        this(b.mediaType, b.headers, b.cached, b.contents.toArray());
    }

    public ReaderResource(MediaType mediaType, Map<String, Object> headers, boolean cached, Object ... contents) throws IOException {
        Object[] objectArray;
        this.mediaType = mediaType;
        this.headers = CollectionUtils.immutableMap(headers);
        if (cached) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = IOUtils.readAll(contents);
        } else {
            objectArray = contents;
        }
        this.contents = objectArray;
    }

    public static Builder create() {
        return new Builder();
    }

    @ResponseHeader(value="*")
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    @ResponseBody
    public Writer writeTo(Writer w) throws IOException {
        for (Object o : this.contents) {
            IOUtils.pipe(o, w);
        }
        return w;
    }

    @Override
    @ResponseHeader(value="Content-Type")
    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String toString() {
        try {
            if (this.contents.length == 1) {
                return IOUtils.read(this.contents[0]);
            }
            return this.writeTo(new StringWriter()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toCommentStrippedString() {
        String s = this.toString();
        String subType = this.mediaType.getSubType();
        if ("html".equals(subType) || "xhtml".equals(subType) || "xml".equals(subType)) {
            s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
        } else if ("json".equals(subType) || "javascript".equals(subType) || "css".equals(subType)) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }

    public Reader getContents() {
        if (this.contents.length == 1 && this.contents[0] instanceof Reader) {
            return (Reader)this.contents[0];
        }
        return new StringReader(this.toString());
    }

    public static class Builder {
        public ArrayList<Object> contents = new ArrayList();
        public MediaType mediaType;
        public Map<String, Object> headers = new LinkedHashMap<String, Object>();
        public boolean cached;

        public Builder mediaType(String mediaType) {
            this.mediaType = MediaType.forString(mediaType);
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder contents(Object ... contents) {
            this.contents.addAll(Arrays.asList(contents));
            return this;
        }

        public Builder header(String name, Object value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder cached() {
            this.cached = true;
            return this;
        }

        public ReaderResource build() throws IOException {
            return new ReaderResource(this);
        }
    }
}

