/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.http.Accept;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.MediaTypeRange;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroupBuilder;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.WriterSerializer;

@ConfigurableContext(nocache=true)
public final class SerializerGroup
extends BeanTraverseContext {
    public static final SerializerGroup EMPTY = SerializerGroup.create().build();
    private final ConcurrentHashMap<String, SerializerMatch> cache = new ConcurrentHashMap();
    private final MediaTypeRange[] mediaTypeRanges;
    private final Serializer[] mediaTypeRangeSerializers;
    private final List<MediaType> mediaTypesList;
    private final List<Serializer> serializers;

    public static SerializerGroupBuilder create() {
        return new SerializerGroupBuilder();
    }

    @Override
    public SerializerGroupBuilder builder() {
        return new SerializerGroupBuilder(this);
    }

    public SerializerGroup(PropertyStore ps, Serializer[] serializers) {
        super(ps);
        this.serializers = CollectionUtils.immutableList(serializers);
        ArrayList<MediaTypeRange> lmtr = new ArrayList<MediaTypeRange>();
        LinkedHashSet<Comparable<MediaTypeRange>> lmt = new LinkedHashSet<Comparable<MediaTypeRange>>();
        ArrayList<Serializer> l = new ArrayList<Serializer>();
        for (Serializer s : serializers) {
            for (MediaTypeRange mediaTypeRange : s.getMediaTypeRanges()) {
                lmtr.add(mediaTypeRange);
                l.add(s);
            }
            for (Comparable<MediaTypeRange> comparable : s.getAcceptMediaTypes()) {
                lmt.add(comparable);
            }
        }
        this.mediaTypeRanges = lmtr.toArray(new MediaTypeRange[lmt.size()]);
        this.mediaTypesList = CollectionUtils.unmodifiableList(new ArrayList(lmt));
        this.mediaTypeRangeSerializers = l.toArray(new Serializer[l.size()]);
    }

    public SerializerMatch getSerializerMatch(String acceptHeader) {
        SerializerMatch sm = this.cache.get(acceptHeader);
        if (sm != null) {
            return sm;
        }
        Accept a = Accept.forString(acceptHeader);
        int match = a.findMatch(this.mediaTypeRanges);
        if (match >= 0) {
            sm = new SerializerMatch(this.mediaTypeRanges[match].getMediaType(), this.mediaTypeRangeSerializers[match]);
            this.cache.putIfAbsent(acceptHeader, sm);
        }
        return this.cache.get(acceptHeader);
    }

    public SerializerMatch getSerializerMatch(MediaType mediaType) {
        return this.getSerializerMatch(mediaType.toString());
    }

    public Serializer getSerializer(String acceptHeader) {
        SerializerMatch sm = this.getSerializerMatch(acceptHeader);
        return sm == null ? null : sm.getSerializer();
    }

    public Serializer getSerializer(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        return this.getSerializer(mediaType.toString());
    }

    public WriterSerializer getWriterSerializer(String acceptHeader) {
        return (WriterSerializer)this.getSerializer(acceptHeader);
    }

    public WriterSerializer getWriterSerializer(MediaType mediaType) {
        return (WriterSerializer)this.getSerializer(mediaType);
    }

    public OutputStreamSerializer getStreamSerializer(String acceptHeader) {
        return (OutputStreamSerializer)this.getSerializer(acceptHeader);
    }

    public OutputStreamSerializer getStreamSerializer(MediaType mediaType) {
        return (OutputStreamSerializer)this.getSerializer(mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypesList;
    }

    public List<Serializer> getSerializers() {
        return this.serializers;
    }
}

