/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.juneau.internal.ThrowableUtils;

public class MultiIterable<E>
implements Iterable<E> {
    final List<Iterator<E>> iterators = new LinkedList<Iterator<E>>();

    public MultiIterable(Iterator<E> ... iterators) {
        for (Iterator<E> i : iterators) {
            this.append(i);
        }
    }

    public MultiIterable<E> append(Iterator<E> iterator) {
        ThrowableUtils.assertFieldNotNull(iterator, "iterator");
        this.iterators.add(iterator);
        return this;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<Iterator<E>> i1;
            Iterator<E> i2;
            {
                this.i1 = MultiIterable.this.iterators.iterator();
                this.i2 = this.i1.hasNext() ? this.i1.next() : null;
            }

            @Override
            public boolean hasNext() {
                while (this.i2 != null && !this.i2.hasNext()) {
                    this.i2 = this.i1.hasNext() ? this.i1.next() : null;
                }
                return this.i2 != null;
            }

            @Override
            public E next() {
                this.hasNext();
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                return this.i2.next();
            }

            @Override
            public void remove() {
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                this.i2.remove();
            }
        };
    }
}

