/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.htmltowiki.syntax.MarkupHelper;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class ADecorator {
    protected final PrintWriter out;
    protected final XHtmlToWikiConfig config;
    protected final XHtmlElementToWikiTranslator chain;

    protected ADecorator(PrintWriter out, XHtmlToWikiConfig config, XHtmlElementToWikiTranslator chain) {
        this.out = out;
        this.config = config;
        this.chain = chain;
    }

    public void decorate(Element e, String ref) throws JDOMException {
        Map<String, String> augmentedWikiLinkAttributes = MarkupHelper.getAugmentedWikiLinkAttributes(e);
        if (this.containsAdditionalLinkAttributes(augmentedWikiLinkAttributes)) {
            String augmentedWikiLink = MarkupHelper.augmentedWikiLinkMapToString(augmentedWikiLinkAttributes);
            this.linkMarkup(e, ref, augmentedWikiLink);
        } else if (!e.getTextTrim().equalsIgnoreCase(ref)) {
            this.linkMarkup(e, ref);
        } else {
            this.linkMarkup(e);
        }
    }

    boolean containsAdditionalLinkAttributes(Map<String, String> augmentedWikiLinkAttributes) {
        return !augmentedWikiLinkAttributes.isEmpty();
    }

    public void decorateFootnote(String text, String href) {
        this.linkMarkup(text, href);
    }

    public void decorateUndefinedLink(Element e) throws JDOMException {
        this.linkMarkup(e);
    }

    protected abstract void linkMarkup(Element var1) throws JDOMException;

    protected abstract void linkMarkup(Element var1, String var2) throws JDOMException;

    protected abstract void linkMarkup(Element var1, String var2, String var3) throws JDOMException;

    protected abstract void linkMarkup(String var1, String var2);
}

