/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider;

import com.vladsch.flexmark.util.html.MutableAttributes;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.NodeAttributeProviderState;
import org.apache.wiki.markdown.nodes.JSPWikiLink;

public class WysiwygEditingAttributeProviderState
implements NodeAttributeProviderState<JSPWikiLink> {
    private final Context wikiContext;
    private final boolean m_wysiwygEditorMode;

    public WysiwygEditingAttributeProviderState(Context wikiContext) {
        this.wikiContext = wikiContext;
        Boolean wysiwygVariable = (Boolean)wikiContext.getVariable("WYSIWYG_EDITOR_MODE");
        this.m_wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
    }

    @Override
    public void setAttributes(MutableAttributes attributes, JSPWikiLink link) {
        if (this.m_wysiwygEditorMode && attributes.getValue((CharSequence)"class") != null) {
            String href = attributes.getValue((CharSequence)"href");
            XHtmlToWikiConfig wikiConfig = new XHtmlToWikiConfig(this.wikiContext);
            String wikiPageLinkUrl = wikiConfig.getWikiJspPage();
            String editPageLinkUrl = wikiConfig.getEditJspPage();
            if (href != null && href.startsWith(wikiPageLinkUrl)) {
                String newHref = href.substring(wikiPageLinkUrl.length());
                newHref = this.wikiContext.getEngine().decodeName(newHref);
                attributes.replaceValue((CharSequence)"href", (CharSequence)newHref.replaceFirst("(.+)#section-.+-(.+)", "$1#$2"));
            } else if (href != null && href.startsWith(editPageLinkUrl)) {
                String title = attributes.getValue((CharSequence)"title");
                if (title != null) {
                    attributes.replaceValue((CharSequence)"title", (CharSequence)"");
                }
                String newHref = href.substring(editPageLinkUrl.length());
                newHref = this.wikiContext.getEngine().decodeName(newHref);
                attributes.replaceValue((CharSequence)"href", (CharSequence)newHref);
            }
        }
    }
}

