/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.event;

import java.util.Set;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WorkflowEvent;

public enum WikiEventEmitter {
    INSTANCE;


    public static WikiEventEmitter get() {
        return INSTANCE;
    }

    public static WorkflowEvent fireWorkflowEvent(Object src, int type) {
        return WikiEventEmitter.fireEvent(new WorkflowEvent(src, type));
    }

    public static WorkflowEvent fireWorkflowEvent(Object src, int type, Object ... args) {
        return WikiEventEmitter.fireEvent(new WorkflowEvent(src, type, args));
    }

    static <T extends WikiEvent> T fireEvent(T event) {
        if (WikiEventManager.isListening((Object)WikiEventEmitter.get())) {
            WikiEventManager.fireEvent((Object)WikiEventEmitter.get(), event);
            return event;
        }
        return null;
    }

    public static void attach(WikiEventListener listener) {
        if (WikiEventManager.isListening((Object)WikiEventEmitter.get())) {
            Set<WikiEventListener> attachedListeners = WikiEventManager.getWikiEventListeners((Object)WikiEventEmitter.get());
            attachedListeners.stream().filter(l -> listener.getClass().isAssignableFrom(l.getClass())).forEach(WikiEventManager::removeWikiEventListener);
        }
        WikiEventEmitter.register(listener);
    }

    public static void register(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener((Object)WikiEventEmitter.get(), listener);
    }
}

