/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

public class ByteUtils {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static String bytes2hex(byte[] bytes) {
        char[] ca = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            ca[i * 2] = hexArray[v >>> 4];
            ca[i * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(ca);
    }

    public static String byte2hex(byte b) {
        return Integer.toHexString(b & 0xFF);
    }

    public static byte[] parseHexBinary(String hex) {
        int len = hex.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + hex);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = ByteUtils.hexToBin(hex.charAt(i));
            int l = ByteUtils.hexToBin(hex.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + hex);
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    public static int hexToBin(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private ByteUtils() {
    }
}

