/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.suigeneris.jrcs.util.ToString;

public class DiffHelper
extends ToString {
    public static Object[] editAll(Object[] text) {
        Object[] result = new String[text.length];
        for (int i = 0; i < text.length; ++i) {
            result[i] = text[i] + " <edited>";
        }
        return result;
    }

    public static Object[] randomEdit(Object[] text) {
        return DiffHelper.randomEdit(text, text.length);
    }

    public static Object[] randomEdit(Object[] text, long seed) {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(text));
        Random r = new Random(seed);
        int nops = r.nextInt(10);
        for (int i = 0; i < nops; ++i) {
            boolean del = r.nextBoolean();
            int pos = r.nextInt(result.size() + 1);
            int len = Math.min(result.size() - pos, 1 + r.nextInt(4));
            if (del && result.size() > 0) {
                result.subList(pos, pos + len).clear();
                continue;
            }
            int k = 0;
            while (k < len) {
                result.add(pos, "[" + i + "] random edit[" + i + "][" + i + "]");
                ++k;
                ++pos;
            }
        }
        return result.toArray();
    }

    public static Object[] shuffle(Object[] text) {
        return DiffHelper.shuffle(text, text.length);
    }

    public static Object[] shuffle(Object[] text, long seed) {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(text));
        Collections.shuffle(result);
        return result.toArray();
    }

    public static Object[] randomSequence(int size) {
        return DiffHelper.randomSequence(size, size);
    }

    public static Object[] randomSequence(int size, long seed) {
        Object[] result = new Integer[size];
        Random r = new Random(seed);
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Integer(r.nextInt(size));
        }
        return result;
    }
}

