/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.admin;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.ui.admin.AdminBean;
import org.apache.wiki.ui.admin.AdminBeanManager;
import org.apache.wiki.ui.admin.beans.CoreBean;
import org.apache.wiki.ui.admin.beans.FilterBean;
import org.apache.wiki.ui.admin.beans.PluginBean;
import org.apache.wiki.ui.admin.beans.SearchManagerBean;
import org.apache.wiki.ui.admin.beans.UserBean;
import org.apache.wiki.util.ClassUtil;

public class DefaultAdminBeanManager
implements WikiEventListener,
AdminBeanManager {
    private final Engine m_engine;
    private final String applicationName;
    private ArrayList<AdminBean> m_allBeans;
    private final MBeanServer m_mbeanServer;
    private static final Logger LOG = LogManager.getLogger(DefaultAdminBeanManager.class);

    public DefaultAdminBeanManager(Engine engine) {
        LOG.info("Using JDK 1.5 Platform MBeanServer");
        this.m_mbeanServer = MBeanServerFactory15.getServer();
        this.m_engine = engine;
        this.applicationName = this.m_engine.getWikiProperties().getProperty("jspwiki.applicationName").trim();
        if (this.m_mbeanServer != null) {
            LOG.info(this.m_mbeanServer.getClass().getName());
            LOG.info(this.m_mbeanServer.getDefaultDomain());
        }
        this.m_engine.addWikiEventListener((WikiEventListener)this);
        this.initialize();
    }

    @Override
    public void initialize() {
        this.reload();
    }

    private String getJMXTitleString(int title) {
        switch (title) {
            case 1: {
                return "Core";
            }
            case 2: {
                return "Editors";
            }
        }
        return "Unknown";
    }

    private void registerAdminBean(AdminBean ab) {
        try {
            ObjectName name;
            if (ab instanceof DynamicMBean && this.m_mbeanServer != null && !this.m_mbeanServer.isRegistered(name = this.getObjectName(ab))) {
                this.m_mbeanServer.registerMBean(ab, name);
            }
            this.m_allBeans.add(ab);
            LOG.info("Registered new admin bean " + ab.getTitle());
        }
        catch (InstanceAlreadyExistsException e) {
            LOG.error("Admin bean already registered to JMX", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            LOG.error("Admin bean cannot be registered to JMX", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOG.error("Your admin bean is not very good", (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Your admin bean name is not very good", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error("Evil NPE occurred", (Throwable)e);
        }
    }

    private ObjectName getObjectName(AdminBean ab) throws MalformedObjectNameException {
        String component = this.getJMXTitleString(ab.getType());
        String title = ab.getTitle();
        return new ObjectName(String.format("%s:component=%s,name=%s (%s)", "JSPWiki", component, title, this.applicationName));
    }

    private void registerBeans(Collection<WikiModuleInfo> c) {
        for (WikiModuleInfo wikiModuleInfo : c) {
            String abname = wikiModuleInfo.getAdminBeanClass();
            try {
                if (abname == null || abname.isEmpty()) continue;
                AdminBean ab = (AdminBean)ClassUtil.buildInstance((String)abname);
                this.registerAdminBean(ab);
            }
            catch (ReflectiveOperationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void reload() {
        this.m_allBeans = new ArrayList();
        try {
            this.registerAdminBean(new CoreBean(this.m_engine));
            this.registerAdminBean(new UserBean(this.m_engine));
            this.registerAdminBean(new SearchManagerBean(this.m_engine));
            this.registerAdminBean(new PluginBean(this.m_engine));
            this.registerAdminBean(new FilterBean(this.m_engine));
        }
        catch (NotCompliantMBeanException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        for (ModuleManager moduleManager : this.m_engine.getManagers(ModuleManager.class)) {
            this.registerBeans(moduleManager.modules());
        }
    }

    @Override
    public List<AdminBean> getAllBeans() {
        if (this.m_allBeans == null) {
            this.reload();
        }
        return this.m_allBeans;
    }

    @Override
    public AdminBean findBean(String id) {
        return this.m_allBeans.stream().filter(ab -> ab.getId().equals(id)).findFirst().orElse(null);
    }

    @Override
    public int getTypeFromString(String type) {
        if ("core".equals(type)) {
            return 1;
        }
        if ("editors".equals(type)) {
            return 2;
        }
        return 0;
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && event.getType() == 1) {
            for (AdminBean m_allBean : this.m_allBeans) {
                try {
                    ObjectName on = this.getObjectName(m_allBean);
                    if (!this.m_mbeanServer.isRegistered(on)) continue;
                    this.m_mbeanServer.unregisterMBean(on);
                    LOG.info("Unregistered AdminBean " + m_allBean.getTitle());
                }
                catch (MalformedObjectNameException e) {
                    LOG.error("Malformed object name when unregistering", (Throwable)e);
                }
                catch (InstanceNotFoundException e) {
                    LOG.error("Object was registered; yet claims that it's not there", (Throwable)e);
                }
                catch (MBeanRegistrationException e) {
                    LOG.error("Registration exception while unregistering", (Throwable)e);
                }
            }
        }
    }

    private static final class MBeanServerFactory15 {
        private MBeanServerFactory15() {
        }

        public static MBeanServer getServer() {
            return ManagementFactory.getPlatformMBeanServer();
        }
    }
}

