/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.security.Permission;
import org.apache.wiki.api.core.Command;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.ui.AbstractCommand;

public final class WikiCommand
extends AbstractCommand {
    public static final Command ADMIN = new WikiCommand(ContextEnum.WIKI_ADMIN, null);
    public static final Command CREATE_GROUP = new WikiCommand(ContextEnum.WIKI_CREATE_GROUP, null, "createGroups");
    public static final Command ERROR = new WikiCommand(ContextEnum.WIKI_ERROR, null, null);
    public static final Command FIND = new WikiCommand(ContextEnum.WIKI_FIND, null, null);
    public static final Command INSTALL = new WikiCommand(ContextEnum.WIKI_INSTALL, null, null);
    public static final Command LOGIN = new WikiCommand(ContextEnum.WIKI_LOGIN, null, "login");
    public static final Command LOGOUT = new WikiCommand(ContextEnum.WIKI_LOGOUT, null, "login");
    public static final Command MESSAGE = new WikiCommand(ContextEnum.WIKI_MESSAGE, null, null);
    public static final Command PREFS = new WikiCommand(ContextEnum.WIKI_PREFS, null, "editProfile");
    public static final Command WORKFLOW = new WikiCommand(ContextEnum.WIKI_WORKFLOW, null, null);
    private final String m_action;
    private final Permission m_permission;

    private WikiCommand(ContextEnum currentContext, String target) {
        this(currentContext.getRequestContext(), currentContext.getUrlPattern(), currentContext.getContentTemplate(), target);
    }

    private WikiCommand(ContextEnum currentContext, String target, String action) {
        this(currentContext.getRequestContext(), currentContext.getUrlPattern(), currentContext.getContentTemplate(), target, action);
    }

    private WikiCommand(String requestContext, String urlPattern, String contentTemplate, String target, String action) {
        super(requestContext, urlPattern, contentTemplate, target);
        this.m_action = action;
        this.m_permission = target == null || this.m_action == null ? null : new WikiPermission(target, action);
    }

    private WikiCommand(String requestContext, String urlPattern, String contentTemplate, String target) {
        super(requestContext, urlPattern, contentTemplate, target);
        this.m_action = null;
        this.m_permission = new AllPermission(target);
    }

    @Override
    public Command targetedCommand(Object target) {
        if (!(target instanceof String)) {
            throw new IllegalArgumentException("Target must non-null and of type String.");
        }
        return new WikiCommand(this.getRequestContext(), this.getURLPattern(), this.getContentTemplate(), (String)target, this.m_action);
    }

    @Override
    public String getName() {
        return this.getJSPFriendlyName();
    }

    public Permission requiredPermission() {
        return this.m_permission;
    }
}

