/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.ajax.AjaxUtil;
import org.apache.wiki.ajax.WikiAjaxDispatcherServlet;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.filters.BasePageFilter;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.search.BasicSearchProvider;
import org.apache.wiki.search.LuceneSearchProvider;
import org.apache.wiki.search.SearchManager;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

public class DefaultSearchManager
extends BasePageFilter
implements SearchManager {
    private static final Logger LOG = LogManager.getLogger(DefaultSearchManager.class);
    private SearchProvider m_searchProvider;

    public DefaultSearchManager(Engine engine, Properties properties) throws FilterException {
        this.initialize(engine, properties);
        WikiEventManager.addWikiEventListener((Object)this.m_engine.getManager(PageManager.class), (WikiEventListener)this);
        WikiAjaxDispatcherServlet.registerServlet("search", new JSONSearch());
    }

    public void initialize(Engine engine, Properties properties) throws FilterException {
        this.m_engine = engine;
        this.loadSearchProvider(properties);
        try {
            this.m_searchProvider.initialize(engine, properties);
        }
        catch (IOException | NoRequiredPropertyException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    private void loadSearchProvider(Properties properties) {
        String providerClassName = TextUtil.getStringProperty((Properties)properties, (String)"jspwiki.searchProvider", (String)"org.apache.wiki.search.LuceneSearchProvider");
        try {
            this.m_searchProvider = (SearchProvider)ClassUtil.buildInstance((String)"org.apache.wiki.search", (String)providerClassName);
        }
        catch (ReflectiveOperationException e) {
            LOG.warn("Failed loading SearchProvider, will use BasicSearchProvider.", (Throwable)e);
        }
        if (null == this.m_searchProvider) {
            this.m_searchProvider = new BasicSearchProvider();
        }
        LOG.debug("Loaded search provider {}", (Object)this.m_searchProvider);
    }

    @Override
    public SearchProvider getSearchEngine() {
        return this.m_searchProvider;
    }

    public void actionPerformed(WikiEvent event) {
        if (event instanceof WikiPageEvent) {
            Page p;
            String pageName = ((WikiPageEvent)event).getPageName();
            if (event.getType() == 26 && (p = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pageName)) != null) {
                this.pageRemoved(p);
            }
            if (event.getType() == 28 && (p = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pageName)) != null) {
                this.reindexPage(p);
            }
        }
    }

    public class JSONSearch
    implements WikiAjaxServlet {
        public static final String AJAX_ACTION_SUGGESTIONS = "suggestions";
        public static final String AJAX_ACTION_PAGES = "pages";
        public static final int DEFAULT_MAX_RESULTS = 20;
        public int maxResults = 20;

        @Override
        public String getServletMapping() {
            return "search";
        }

        @Override
        public void service(HttpServletRequest req, HttpServletResponse resp, String actionName, List<String> params) throws IOException {
            String result = "";
            if (StringUtils.isNotBlank((CharSequence)actionName)) {
                if (params.isEmpty()) {
                    return;
                }
                String itemId = params.get(0);
                LOG.debug("itemId=" + itemId);
                if (params.size() > 1) {
                    String maxResultsParam = params.get(1);
                    LOG.debug("maxResultsParam=" + maxResultsParam);
                    if (StringUtils.isNotBlank((CharSequence)maxResultsParam) && StringUtils.isNumeric((CharSequence)maxResultsParam)) {
                        this.maxResults = Integer.parseInt(maxResultsParam);
                    }
                }
                if (actionName.equals(AJAX_ACTION_SUGGESTIONS)) {
                    LOG.debug("Calling getSuggestions() START");
                    List<String> callResults = this.getSuggestions(itemId, this.maxResults);
                    LOG.debug("Calling getSuggestions() DONE. " + callResults.size());
                    result = AjaxUtil.toJson(callResults);
                } else if (actionName.equals(AJAX_ACTION_PAGES)) {
                    LOG.debug("Calling findPages() START");
                    Context wikiContext = Wiki.context().create(DefaultSearchManager.this.m_engine, req, ContextEnum.PAGE_VIEW.getRequestContext());
                    List<Map<String, Object>> callResults = this.findPages(itemId, this.maxResults, wikiContext);
                    LOG.debug("Calling findPages() DONE. " + callResults.size());
                    result = AjaxUtil.toJson(callResults);
                }
            }
            LOG.debug("result=" + result);
            resp.getWriter().write(result);
        }

        public List<String> getSuggestions(String wikiName, int maxLength) {
            StopWatch sw = new StopWatch();
            sw.start();
            ArrayList<String> list = new ArrayList<String>(maxLength);
            if (!wikiName.isEmpty()) {
                String filename = "";
                int pos = wikiName.indexOf("/");
                if (pos >= 0) {
                    filename = wikiName.substring(pos).toLowerCase();
                    wikiName = wikiName.substring(0, pos);
                }
                String cleanWikiName = MarkupParser.cleanLink(wikiName).toLowerCase() + filename;
                String oldStyleName = MarkupParser.wikifyLink(wikiName).toLowerCase() + filename;
                Set<String> allPages = ((ReferenceManager)DefaultSearchManager.this.m_engine.getManager(ReferenceManager.class)).findCreated();
                int counter = 0;
                Iterator<String> i = allPages.iterator();
                while (i.hasNext() && counter < maxLength) {
                    String p = i.next();
                    String pp = p.toLowerCase();
                    if (!pp.startsWith(cleanWikiName) && !pp.startsWith(oldStyleName)) continue;
                    list.add(p);
                    ++counter;
                }
            }
            sw.stop();
            LOG.debug("Suggestion request for {} done in {}", (Object)wikiName, (Object)sw);
            return list;
        }

        public List<Map<String, Object>> findPages(String searchString, int maxLength, Context wikiContext) {
            StopWatch sw = new StopWatch();
            sw.start();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(maxLength);
            if (!searchString.isEmpty()) {
                try {
                    Collection<SearchResult> c = DefaultSearchManager.this.m_searchProvider instanceof LuceneSearchProvider ? ((LuceneSearchProvider)DefaultSearchManager.this.m_searchProvider).findPages(searchString, 0, wikiContext) : DefaultSearchManager.this.m_searchProvider.findPages(searchString, wikiContext);
                    Iterator<SearchResult> i = c.iterator();
                    for (int count = 0; i.hasNext() && count < maxLength; ++count) {
                        SearchResult sr = i.next();
                        HashMap<String, Object> hm = new HashMap<String, Object>();
                        hm.put("page", sr.getPage().getName());
                        hm.put("score", sr.getScore());
                        list.add(hm);
                    }
                }
                catch (Exception e) {
                    LOG.info("AJAX search failed; ", (Throwable)e);
                }
            }
            sw.stop();
            LOG.debug("AJAX search complete in {}", (Object)sw);
            return list;
        }
    }
}

