/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.auth.login.UserDatabaseCallback;
import org.apache.wiki.auth.login.WikiEngineCallback;

public class WikiCallbackHandler
implements CallbackHandler {
    private final HttpServletRequest m_request;
    private final Engine m_engine;
    private final String m_password;
    private final String m_username;

    public WikiCallbackHandler(Engine engine, HttpServletRequest request, String username, String password) {
        this.m_request = request;
        this.m_engine = engine;
        this.m_username = username;
        this.m_password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof HttpRequestCallback) {
                ((HttpRequestCallback)callback).setRequest(this.m_request);
                continue;
            }
            if (callback instanceof WikiEngineCallback) {
                ((WikiEngineCallback)callback).setEngine(this.m_engine);
                continue;
            }
            if (callback instanceof UserDatabaseCallback) {
                ((UserDatabaseCallback)callback).setUserDatabase(((UserManager)this.m_engine.getManager(UserManager.class)).getUserDatabase());
                continue;
            }
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.m_username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.m_password.toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

