/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.assemblers;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.RuleSet;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.ontapi.assemblers.OA;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.rulesys.Rule;

public class OntRuleSetAssembler
extends AssemblerBase {
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, OA.RuleSet);
        return OntRuleSetAssembler.createRuleSet(a, root);
    }

    public static RuleSet createRuleSet(Assembler a, Resource root) {
        return RuleSet.create(OntRuleSetAssembler.addRules(new ArrayList<Rule>(), a, root));
    }

    public static List<Rule> addRules(List<Rule> result, Assembler a, Resource root) {
        OntRuleSetAssembler.addLiteralRules(root, result);
        OntRuleSetAssembler.addIndirectRules(a, root, result);
        OntRuleSetAssembler.addExternalRules(root, result);
        return result;
    }

    private static void addIndirectRules(Assembler a, Resource root, List<Rule> result) {
        root.listProperties(OA.rules).forEach(statement -> {
            Resource r = OntRuleSetAssembler.getResource((Statement)statement);
            result.addAll(((RuleSet)a.open(r)).getRules());
        });
    }

    private static void addExternalRules(Resource root, List<Rule> result) {
        root.listProperties(OA.rulesFrom).forEach(statement -> {
            Resource s = OntRuleSetAssembler.getResource((Statement)statement);
            result.addAll(Rule.rulesFromURL((String)s.getURI()));
        });
    }

    private static void addLiteralRules(Resource root, List<Rule> result) {
        root.listProperties(OA.rule).forEach(statement -> {
            String s = OntRuleSetAssembler.getString((Statement)statement);
            result.addAll(Rule.parseRules((String)s));
        });
    }
}

