/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.rdfs.engine.ApplyRDFS;
import org.apache.jena.rdfs.engine.CxtInf;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.rdfs.engine.Match;
import org.apache.jena.rdfs.engine.Output;
import org.apache.jena.rdfs.setup.ConfigRDFS;

public abstract class MatchRDFS<X, T>
extends CxtInf<X, T>
implements Match<X, T> {
    private final Function<T, Stream<T>> applyInf = t -> {
        ArrayList<Object> x = new ArrayList<Object>();
        x.add(t);
        Output<Object> dest = (s, p, o) -> x.add(this.dstCreate(s, p, o));
        ApplyRDFS streamInf = new ApplyRDFS(setup, mapper);
        streamInf.infer(mapper.subject(t), mapper.predicate(t), mapper.object(t), dest);
        return x.stream();
    };

    public MatchRDFS(ConfigRDFS<X> setup, MapperX<X, T> mapper) {
        super(setup, mapper);
    }

    @Override
    public final Stream<T> match(X s, X p, X o) {
        return this.matchWithInf(s, p, o);
    }

    protected abstract boolean sourceContains(X var1, X var2, X var3);

    protected abstract Stream<T> sourceFind(X var1, X var2, X var3);

    protected abstract T dstCreate(X var1, X var2, X var3);

    protected final X subject(T tuple) {
        return this.mapper.subject(tuple);
    }

    protected final X predicate(T tuple) {
        return this.mapper.predicate(tuple);
    }

    protected final X object(T tuple) {
        return this.mapper.object(tuple);
    }

    private Stream<T> matchWithInf(X _subject, X _predicate, X _object) {
        X subject = this.any(_subject);
        X predicate = this.any(_predicate);
        X object = this.any(_object);
        if (this.rdfType.equals(predicate)) {
            if (this.isTerm(subject)) {
                if (this.isTerm(object)) {
                    return this.find_X_type_T(subject, object);
                }
                return this.find_X_type_ANY(subject);
            }
            if (this.isTerm(object)) {
                return this.find_ANY_type_T(object);
            }
            return this.find_ANY_type_ANY();
        }
        if (this.isANY(predicate)) {
            if (this.isTerm(subject)) {
                if (this.isTerm(object)) {
                    return this.find_X_ANY_Y(subject, object);
                }
                return this.find_X_ANY_ANY(subject);
            }
            if (this.isTerm(object)) {
                return this.find_ANY_ANY_Y(object);
            }
            return this.find_ANY_ANY_ANY();
        }
        if (this.rdfsSubPropertyOf.equals(predicate) || this.rdfsSubClassOf.equals(predicate)) {
            return this.sourceFind(subject, predicate, object);
        }
        return this.find_ANY_property_ANY(subject, predicate, object);
    }

    private Stream<T> find_ANY_property_ANY(X subject, X predicate, X object) {
        Stream<T> tuples = this.sourceFind(subject, predicate, object);
        Set<X> predicates = this.setup.getSubProperties(predicate);
        if (MatchRDFS.isEmpty(predicates)) {
            return tuples;
        }
        for (X p : predicates) {
            Stream<Object> stream = this.sourceFind(subject, p, object);
            stream = stream.map(tuple -> this.dstCreate(this.subject(tuple), predicate, this.object(tuple)));
            tuples = Stream.concat(tuples, stream);
        }
        tuples = tuples.distinct();
        return tuples;
    }

    private Stream<T> find_X_type_T(X subject, X object) {
        if (this.sourceContains(subject, this.rdfType, object)) {
            return Stream.of(this.dstCreate(subject, this.rdfType, object));
        }
        if (this.setup.hasOnlyPropertyDeclarations()) {
            return Stream.empty();
        }
        Set<Object> types = new HashSet();
        this.accTypesRange(types, subject);
        if (types.contains(object)) {
            return Stream.of(this.dstCreate(subject, this.rdfType, object));
        }
        this.accTypesDomain(types, subject);
        if (types.contains(object)) {
            return Stream.of(this.dstCreate(subject, this.rdfType, object));
        }
        this.accTypes(types, subject);
        if (types.contains(object)) {
            return Stream.of(this.dstCreate(subject, this.rdfType, object));
        }
        if ((types = this.superTypes((X)types)).contains(object)) {
            return Stream.of(this.dstCreate(subject, this.rdfType, object));
        }
        return Stream.empty();
    }

    private Stream<T> find_X_type_ANY(X subject) {
        Set<Object> types = new HashSet();
        this.accTypesRange(types, subject);
        this.accTypesDomain(types, subject);
        this.accTypes(types, subject);
        types = this.superTypes((X)types);
        return types.stream().map(type -> this.dstCreate(subject, this.rdfType, type));
    }

    private Stream<T> find_ANY_type_T(X type) {
        if (this.setup.hasOnlyPropertyDeclarations()) {
            return this.sourceFind(this.ANY, this.rdfType, type);
        }
        HashSet tuples = new HashSet();
        Set<X> types = this.subTypes(type);
        this.accInstances(tuples, types, type);
        this.accInstancesRange(tuples, types, type);
        this.accInstancesDomain(tuples, types, type);
        return tuples.stream();
    }

    private Stream<T> find_ANY_type_ANY() {
        if (this.setup.hasOnlyPropertyDeclarations()) {
            return this.sourceFind(this.ANY, this.rdfType, this.ANY);
        }
        Stream<T> stream = this.sourceFind(this.ANY, this.ANY, this.ANY);
        stream = this.infFilter(stream, null, this.rdfType, null);
        return stream;
    }

    private Stream<T> find_X_ANY_Y(X subject, X object) {
        Stream<T> stream = this.sourceFind(subject, this.ANY, this.ANY);
        if (this.setup.hasRangeDeclarations()) {
            stream = Stream.concat(stream, this.sourceFind(this.ANY, this.ANY, subject));
        }
        return this.infFilter(stream, subject, this.ANY, object);
    }

    private Stream<T> find_X_ANY_ANY(X subject) {
        return this.find_X_ANY_Y(subject, this.ANY);
    }

    private Stream<T> find_ANY_ANY_Y(X object) {
        Stream<Object> stream = this.sourceFind(this.ANY, this.ANY, object);
        stream = stream.filter(triple -> !this.predicate(triple).equals(this.rdfType));
        stream = Stream.concat(stream, this.find_ANY_type_T(object));
        stream = this.withSuperProperties(stream);
        return stream;
    }

    private Stream<T> find_ANY_ANY_ANY() {
        Stream<Object> stream = this.sourceFind(this.ANY, this.ANY, this.ANY);
        stream = stream.filter(triple -> !this.predicate(triple).equals(this.rdfType));
        stream = Stream.concat(stream, this.find_ANY_type_ANY());
        stream = this.withSuperProperties(stream);
        return stream;
    }

    private Stream<T> withSuperProperties(Stream<T> stream) {
        return stream.flatMap(triple -> {
            X predicate = this.predicate(triple);
            Set<X> predicates = this.setup.getSuperProperties(predicate);
            if (MatchRDFS.isEmpty(predicates)) {
                return Stream.of(triple);
            }
            ArrayList<Object> acc = new ArrayList<Object>();
            acc.add(triple);
            X subject = this.subject(triple);
            X object = this.object(triple);
            predicates.forEach(p -> acc.add(this.dstCreate(subject, p, object)));
            return acc.stream();
        });
    }

    private Stream<T> withSuperClasses(Stream<T> stream) {
        return stream.flatMap(triple -> {
            X predicate = this.predicate(triple);
            if (!this.rdfType.equals(predicate)) {
                return Stream.of(triple);
            }
            X objType = this.object(triple);
            Set<X> subClasses = this.setup.getSuperClasses(objType);
            if (MatchRDFS.isEmpty(subClasses)) {
                return Stream.of(triple);
            }
            ArrayList<Object> acc = new ArrayList<Object>();
            acc.add(triple);
            X subject = this.subject(triple);
            subClasses.forEach(c -> acc.add(this.dstCreate(subject, this.rdfType, c)));
            return acc.stream();
        });
    }

    private Set<X> subOf(X predicate, X node) {
        if (predicate.equals(this.rdfsSubClassOf)) {
            return this.setup.getSubClassesInc(node);
        }
        if (predicate.equals(this.rdfsSubPropertyOf)) {
            return this.setup.getSubPropertiesInc(node);
        }
        throw new InternalErrorException("MatchRDFS.subOf called with " + String.valueOf(predicate));
    }

    private Set<X> superOf(X node, X predicate) {
        Objects.requireNonNull(node);
        if (predicate.equals(this.rdfsSubClassOf)) {
            return this.setup.getSuperClassesInc(node);
        }
        if (predicate.equals(this.rdfsSubPropertyOf)) {
            return this.setup.getSuperPropertiesInc(node);
        }
        throw new InternalErrorException("MatchRDFS.superOf called with " + String.valueOf(predicate));
    }

    private Stream<T> expand(Stream<T> stream, Map<X, Set<X>> map, X predicate) {
        if (MatchRDFS.isEmpty(map)) {
            return stream;
        }
        Stream stream2 = map.entrySet().stream().flatMap(e2 -> ((Set)e2.getValue()).stream().map(x -> this.dstCreate(e2.getKey(), predicate, x)));
        return Stream.concat(stream, stream2);
    }

    private Stream<T> infFilter(Stream<T> input, X subject, X predicate, X object) {
        Stream<Object> stream = input.flatMap(this.applyInf::apply);
        boolean check_s = this.isTerm(subject);
        boolean check_p = this.isTerm(predicate);
        boolean check_o = this.isTerm(object);
        if (!(check_s || check_p || check_o)) {
            return stream;
        }
        Predicate<Object> filter = triple -> !(check_s && !this.subject(triple).equals(subject) || check_p && !this.predicate(triple).equals(predicate) || check_o && !this.object(triple).equals(object));
        stream = stream.filter(filter);
        return stream;
    }

    private void accInstances(Set<T> tuples, Set<X> types, X requestedType) {
        for (X type : types) {
            Stream<Object> stream = this.sourceFind(this.ANY, this.rdfType, type);
            stream.forEach(triple -> tuples.add(this.dstCreate(this.subject(triple), this.rdfType, requestedType)));
        }
    }

    private void accInstancesDomain(Set<T> tuples, Set<X> types, X requestedType) {
        for (X type : types) {
            Set<X> predicates = this.setup.getPropertiesByDomain(type);
            if (MatchRDFS.isEmpty(predicates)) continue;
            predicates.forEach(p -> {
                Stream<Object> stream = this.sourceFind(this.ANY, p, this.ANY);
                stream.forEach(triple -> tuples.add(this.dstCreate(this.subject(triple), this.rdfType, requestedType)));
            });
        }
    }

    private void accInstancesRange(Set<T> tuples, Set<X> types, X requestedType) {
        for (X type : types) {
            Set<X> predicates = this.setup.getPropertiesByRange(type);
            if (MatchRDFS.isEmpty(predicates)) continue;
            predicates.forEach(p -> {
                Stream<Object> stream = this.sourceFind(this.ANY, p, this.ANY);
                stream.forEach(triple -> tuples.add(this.dstCreate(this.object(triple), this.rdfType, requestedType)));
            });
        }
    }

    private void accTypes(Set<X> types, X subject) {
        Stream<Object> stream = this.sourceFind(subject, this.rdfType, this.ANY);
        stream.forEach(triple -> types.add(this.object(triple)));
    }

    private void accTypesDomain(Set<X> types, X X) {
        Stream<Object> stream = this.sourceFind(X, this.ANY, this.ANY);
        stream.forEach(triple -> {
            X p = this.predicate(triple);
            Set<X> x = this.setup.getDomain(p);
            types.addAll(x);
        });
    }

    private void accTypesRange(Set<X> types, X X) {
        Stream<Object> stream = this.sourceFind(this.ANY, this.ANY, X);
        stream.forEach(triple -> {
            X p = this.predicate(triple);
            Set<X> x = this.setup.getRange(p);
            types.addAll(x);
        });
    }

    private Set<X> subTypes(Set<X> types) {
        HashSet<X> x = new HashSet<X>();
        for (X type : types) {
            Set<X> y = this.setup.getSubClasses(type);
            x.addAll(y);
            x.add(type);
        }
        return x;
    }

    private Set<X> superTypes(Set<X> types) {
        HashSet<X> x = new HashSet<X>();
        for (X type : types) {
            Set<X> y = this.setup.getSuperClasses(type);
            x.addAll(y);
            x.add(type);
        }
        return x;
    }

    private Set<X> subTypes(X type) {
        Set<X> y = this.setup.getSubClassesInc(type);
        if (MatchRDFS.isEmpty(y)) {
            return Collections.singleton(type);
        }
        return y;
    }

    private Set<X> superTypes(X type) {
        Set<X> y = this.setup.getSuperClassesInc(type);
        if (MatchRDFS.isEmpty(y)) {
            return Collections.singleton(type);
        }
        return y;
    }

    private static <S> boolean isEmpty(Set<S> set) {
        return set == null || set.isEmpty();
    }

    private static <S> boolean isEmpty(Map<S, ?> map) {
        return map == null || map.isEmpty();
    }
}

