/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyScope {
    ACCOUNT("ACCOUNT"),
    RESOURCE("RESOURCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyScope> VALUE_MAP;
    private final String value;

    private PolicyScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyScope> knownValues() {
        EnumSet<PolicyScope> knownValues = EnumSet.allOf(PolicyScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyScope.class, PolicyScope::toString);
    }
}

