/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.IndexSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndexPolicy> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(IndexPolicy.getter(IndexPolicy::logGroupIdentifier)).setter(IndexPolicy.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final SdkField<Long> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdateTime").getter(IndexPolicy.getter(IndexPolicy::lastUpdateTime)).setter(IndexPolicy.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(IndexPolicy.getter(IndexPolicy::policyDocument)).setter(IndexPolicy.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(IndexPolicy.getter(IndexPolicy::policyName)).setter(IndexPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(IndexPolicy.getter(IndexPolicy::sourceAsString)).setter(IndexPolicy.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD, LAST_UPDATE_TIME_FIELD, POLICY_DOCUMENT_FIELD, POLICY_NAME_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IndexPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logGroupIdentifier;
    private final Long lastUpdateTime;
    private final String policyDocument;
    private final String policyName;
    private final String source;

    private IndexPolicy(BuilderImpl builder) {
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.policyDocument = builder.policyDocument;
        this.policyName = builder.policyName;
        this.source = builder.source;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    public final Long lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final IndexSource source() {
        return IndexSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexPolicy)) {
            return false;
        }
        IndexPolicy other = (IndexPolicy)obj;
        return Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.sourceAsString(), other.sourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IndexPolicy").add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("PolicyDocument", (Object)this.policyDocument()).add("PolicyName", (Object)this.policyName()).add("Source", (Object)this.sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexPolicy, T> g) {
        return obj -> g.apply((IndexPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupIdentifier;
        private Long lastUpdateTime;
        private String policyDocument;
        private String policyName;
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexPolicy model) {
            this.logGroupIdentifier(model.logGroupIdentifier);
            this.lastUpdateTime(model.lastUpdateTime);
            this.policyDocument(model.policyDocument);
            this.policyName(model.policyName);
            this.source(model.source);
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final Long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(IndexSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public IndexPolicy build() {
            return new IndexPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndexPolicy> {
        public Builder logGroupIdentifier(String var1);

        public Builder lastUpdateTime(Long var1);

        public Builder policyDocument(String var1);

        public Builder policyName(String var1);

        public Builder source(String var1);

        public Builder source(IndexSource var1);
    }
}

