/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.dao.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;

public class DropEntityResult
extends BaseResult {
    private final Long cleanupTaskId;

    public DropEntityResult(@Nonnull BaseResult.ReturnStatus errorStatus, @Nullable String extraInformation) {
        super(errorStatus, extraInformation);
        this.cleanupTaskId = null;
    }

    public DropEntityResult() {
        super(BaseResult.ReturnStatus.SUCCESS);
        this.cleanupTaskId = null;
    }

    public DropEntityResult(long cleanupTaskId) {
        super(BaseResult.ReturnStatus.SUCCESS);
        this.cleanupTaskId = cleanupTaskId;
    }

    @JsonCreator
    private DropEntityResult(@JsonProperty(value="returnStatus") @Nonnull BaseResult.ReturnStatus returnStatus, @JsonProperty(value="extraInformation") String extraInformation, @JsonProperty(value="cleanupTaskId") Long cleanupTaskId) {
        super(returnStatus, extraInformation);
        this.cleanupTaskId = cleanupTaskId;
    }

    public Long getCleanupTaskId() {
        return this.cleanupTaskId;
    }

    @JsonIgnore
    public boolean failedBecauseNotEmpty() {
        BaseResult.ReturnStatus status = this.getReturnStatus();
        return status == BaseResult.ReturnStatus.CATALOG_NOT_EMPTY || status == BaseResult.ReturnStatus.NAMESPACE_NOT_EMPTY;
    }

    public boolean isEntityUnDroppable() {
        return this.getReturnStatus() == BaseResult.ReturnStatus.ENTITY_UNDROPPABLE;
    }
}

