/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.identity.dpo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import org.apache.polaris.core.identity.ServiceIdentityType;
import org.apache.polaris.core.identity.dpo.AwsIamServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.provider.ServiceIdentityProvider;
import org.apache.polaris.core.secrets.SecretReference;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="identityTypeCode")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AwsIamServiceIdentityInfoDpo.class, name="1")})
public abstract class ServiceIdentityInfoDpo {
    @JsonProperty(value="identityTypeCode")
    private final int identityTypeCode;
    @JsonProperty(value="identityInfoReference")
    private final SecretReference identityInfoReference;

    public ServiceIdentityInfoDpo(@JsonProperty(value="identityTypeCode", required=true) int identityTypeCode, @JsonProperty(value="identityInfoReference", required=false) @Nullable SecretReference identityInfoReference) {
        this.identityTypeCode = identityTypeCode;
        this.identityInfoReference = identityInfoReference;
    }

    public int getIdentityTypeCode() {
        return this.identityTypeCode;
    }

    @JsonIgnore
    public ServiceIdentityType getIdentityType() {
        return ServiceIdentityType.fromCode(this.identityTypeCode);
    }

    @JsonProperty
    public SecretReference getIdentityInfoReference() {
        return this.identityInfoReference;
    }

    @Nullable
    public ServiceIdentityInfo asServiceIdentityInfoModel(ServiceIdentityProvider serviceIdentityProvider) {
        Preconditions.checkNotNull((Object)serviceIdentityProvider, (Object)"Need ServiceIdentityProvider to inject service identity info, should not be null");
        return serviceIdentityProvider.getServiceIdentityInfo(this).orElse(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identityTypeCode", this.getIdentityTypeCode()).toString();
    }
}

