/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc.models;

import jakarta.annotation.Nullable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.entity.PolarisEvent;
import org.apache.polaris.immutables.PolarisImmutable;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.models.Converter;
import org.apache.polaris.persistence.relational.jdbc.models.ImmutableModelEvent;

@PolarisImmutable
public interface ModelEvent
extends Converter<PolarisEvent> {
    public static final String TABLE_NAME = "EVENTS";
    public static final List<String> ALL_COLUMNS = List.of("catalog_id", "event_id", "request_id", "event_type", "timestamp_ms", "principal_name", "resource_type", "resource_identifier", "additional_properties");

    public String getCatalogId();

    public String getEventId();

    @Nullable
    public String getRequestId();

    public String getEventType();

    public long getTimestampMs();

    @Nullable
    public String getPrincipalName();

    public PolarisEvent.ResourceType getResourceType();

    public String getResourceIdentifier();

    public String getAdditionalProperties();

    @Override
    default public PolarisEvent fromResultSet(ResultSet rs) throws SQLException {
        ImmutableModelEvent modelEvent = ImmutableModelEvent.builder().catalogId(rs.getString("catalog_id")).eventId(rs.getString("event_id")).requestId(rs.getString("request_id")).eventType(rs.getString("event_type")).timestampMs(rs.getLong("timestamp_ms")).principalName(rs.getString("actor")).resourceType(PolarisEvent.ResourceType.valueOf((String)rs.getString("resource_type"))).resourceIdentifier(rs.getString("resource_identifier")).additionalProperties(rs.getString("additional_properties")).build();
        return ModelEvent.toEvent(modelEvent);
    }

    @Override
    default public Map<String, Object> toMap(DatabaseType databaseType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("catalog_id", this.getCatalogId());
        map.put("event_id", this.getEventId());
        map.put("request_id", this.getRequestId());
        map.put("event_type", this.getEventType());
        map.put("timestamp_ms", this.getTimestampMs());
        map.put("principal_name", this.getPrincipalName());
        map.put("resource_type", this.getResourceType().toString());
        map.put("resource_identifier", this.getResourceIdentifier());
        if (databaseType.equals((Object)DatabaseType.POSTGRES)) {
            map.put("additional_properties", this.toJsonbPGobject(this.getAdditionalProperties()));
        } else {
            map.put("additional_properties", this.getAdditionalProperties());
        }
        return map;
    }

    public static ModelEvent fromEvent(PolarisEvent event) {
        if (event == null) {
            return null;
        }
        return ImmutableModelEvent.builder().catalogId(event.getCatalogId()).eventId(event.getId()).requestId(event.getRequestId()).eventType(event.getEventType()).timestampMs(event.getTimestampMs()).principalName(event.getPrincipalName()).resourceType(event.getResourceType()).resourceIdentifier(event.getResourceIdentifier()).additionalProperties(event.getAdditionalProperties()).build();
    }

    public static PolarisEvent toEvent(ModelEvent model) {
        if (model == null) {
            return null;
        }
        PolarisEvent polarisEvent = new PolarisEvent(model.getCatalogId(), model.getEventId(), model.getRequestId(), model.getEventType(), model.getTimestampMs(), model.getPrincipalName(), model.getResourceType(), model.getResourceIdentifier());
        polarisEvent.setAdditionalProperties(model.getAdditionalProperties());
        return polarisEvent;
    }
}

