/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.List;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.actions.SnapshotUpdate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public interface RewriteDataFiles
extends SnapshotUpdate<RewriteDataFiles, Result> {
    public static final String PARTIAL_PROGRESS_ENABLED = "partial-progress.enabled";
    public static final boolean PARTIAL_PROGRESS_ENABLED_DEFAULT = false;
    public static final String PARTIAL_PROGRESS_MAX_COMMITS = "partial-progress.max-commits";
    public static final int PARTIAL_PROGRESS_MAX_COMMITS_DEFAULT = 10;
    public static final String PARTIAL_PROGRESS_MAX_FAILED_COMMITS = "partial-progress.max-failed-commits";
    public static final String MAX_FILE_GROUP_SIZE_BYTES = "max-file-group-size-bytes";
    public static final long MAX_FILE_GROUP_SIZE_BYTES_DEFAULT = 0x1900000000L;
    public static final String MAX_CONCURRENT_FILE_GROUP_REWRITES = "max-concurrent-file-group-rewrites";
    public static final int MAX_CONCURRENT_FILE_GROUP_REWRITES_DEFAULT = 5;
    public static final String TARGET_FILE_SIZE_BYTES = "target-file-size-bytes";
    public static final String USE_STARTING_SEQUENCE_NUMBER = "use-starting-sequence-number";
    public static final boolean USE_STARTING_SEQUENCE_NUMBER_DEFAULT = true;
    public static final String REMOVE_DANGLING_DELETES = "remove-dangling-deletes";
    public static final boolean REMOVE_DANGLING_DELETES_DEFAULT = false;
    public static final String REWRITE_JOB_ORDER = "rewrite-job-order";
    public static final String REWRITE_JOB_ORDER_DEFAULT = RewriteJobOrder.NONE.orderName();
    public static final String OUTPUT_SPEC_ID = "output-spec-id";

    default public RewriteDataFiles binPack() {
        return this;
    }

    default public RewriteDataFiles sort() {
        throw new UnsupportedOperationException("SORT Rewrite Strategy not implemented for this framework");
    }

    default public RewriteDataFiles sort(SortOrder sortOrder) {
        throw new UnsupportedOperationException("SORT Rewrite Strategy not implemented for this framework");
    }

    default public RewriteDataFiles zOrder(String ... columns) {
        throw new UnsupportedOperationException("Z-ORDER Rewrite Strategy not implemented for this framework");
    }

    public RewriteDataFiles filter(Expression var1);

    public static interface FileGroupInfo {
        public int globalIndex();

        public int partitionIndex();

        public StructLike partition();
    }

    public static interface FileGroupFailureResult {
        public FileGroupInfo info();

        public int dataFilesCount();
    }

    public static interface FileGroupRewriteResult {
        public FileGroupInfo info();

        public int addedDataFilesCount();

        public int rewrittenDataFilesCount();

        default public long rewrittenBytesCount() {
            return 0L;
        }

        default public int removedDeleteFilesCount() {
            return 0;
        }
    }

    public static interface Result {
        public List<FileGroupRewriteResult> rewriteResults();

        default public List<FileGroupFailureResult> rewriteFailures() {
            return ImmutableList.of();
        }

        default public int addedDataFilesCount() {
            return this.rewriteResults().stream().mapToInt(FileGroupRewriteResult::addedDataFilesCount).sum();
        }

        default public int rewrittenDataFilesCount() {
            return this.rewriteResults().stream().mapToInt(FileGroupRewriteResult::rewrittenDataFilesCount).sum();
        }

        default public long rewrittenBytesCount() {
            return this.rewriteResults().stream().mapToLong(FileGroupRewriteResult::rewrittenBytesCount).sum();
        }

        default public int failedDataFilesCount() {
            return this.rewriteFailures().stream().mapToInt(FileGroupFailureResult::dataFilesCount).sum();
        }

        default public int removedDeleteFilesCount() {
            return this.rewriteResults().stream().mapToInt(FileGroupRewriteResult::removedDeleteFilesCount).sum();
        }
    }
}

